/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.wooden;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import zornco.bedcraftbeyond.core.ModContent;
import zornco.bedcraftbeyond.core.util.items.ItemHandlerGridHelper;
import zornco.bedcraftbeyond.core.util.items.ItemHelper;
import zornco.bedcraftbeyond.frames.registry.FrameHelper;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;

public class RecipeBedFrameWood
implements IRecipe {
    private int woodSlabID = OreDictionary.getOreID((String)"slabWood");

    public boolean func_77569_a(InventoryCrafting crafting, World worldIn) {
        IItemHandler slab;
        IItemHandler wood;
        Dimension craftingSize = new Dimension(crafting.func_174922_i(), crafting.func_174923_h());
        InvWrapper inv = new InvWrapper((IInventory)crafting);
        try {
            wood = ItemHandlerGridHelper.getItemsWrapped((IItemHandler)inv, craftingSize, new Rectangle(0, 2, 3, 1));
            slab = ItemHandlerGridHelper.getItemsWrapped((IItemHandler)inv, craftingSize, new Rectangle(0, 1, 3, 1));
        }
        catch (IndexOutOfBoundsException iob) {
            return false;
        }
        if (!ItemHelper.areItemStacksEqual(wood)) {
            return false;
        }
        if (!ItemHelper.areItemStacksEqual(slab)) {
            return false;
        }
        if (wood.getSlots() < 3 || !FrameRegistry.isValidFrameMaterial(FrameRegistry.EnumFrameType.WOOD, wood.getStackInSlot(0))) {
            return false;
        }
        if (slab.getSlots() < 3) {
            return false;
        }
        return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)slab.getStackInSlot(0)), (int)this.woodSlabID);
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        InvWrapper wrapped = new InvWrapper((IInventory)inv);
        ItemStack wood = wrapped.extractItem(6, 1, true);
        if (wood == null) {
            return null;
        }
        ItemStack bedFrame = new ItemStack((Item)ModContent.Items.woodenBed, 1);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("frame", (NBTBase)FrameHelper.getFrameTag(wood));
        bedFrame.func_77982_d(tags);
        return bedFrame;
    }

    public int func_77570_a() {
        return 9;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return new ItemStack((Item)ModContent.Items.woodenBed, 1);
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

