/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.wooden;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.frames.BedFrameUpdate;
import zornco.bedcraftbeyond.frames.base.TileGenericBed;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameHelper;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;
import zornco.bedcraftbeyond.linens.ILinenHolder;
import zornco.bedcraftbeyond.linens.LinenHandler;
import zornco.bedcraftbeyond.linens.LinenUpdate;
import zornco.bedcraftbeyond.parts.Part;
import zornco.bedcraftbeyond.storage.handling.CapabilityStorageHandler;
import zornco.bedcraftbeyond.storage.handling.StorageHandler;

public class TileWoodenBed
extends TileGenericBed
implements ILinenHolder {
    private Color plankColor;
    public ResourceLocation plankType;
    protected int plankMeta;
    protected LinenHandler linens;
    protected StorageHandler storage = new DrawerStorage();

    public TileWoodenBed() {
        this.linens = new LinenHandler();
    }

    public TileWoodenBed(World w) {
        super(w);
        this.linens = new LinenHandler();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        if (this.linens != null) {
            tags.func_74782_a("linens", (NBTBase)this.linens.serializeNBT());
        }
        if (this.plankColor != null) {
            tags.func_74768_a("plankColor", this.plankColor.getRGB());
        }
        if (this.plankType != null) {
            tags.func_74778_a("plankType", this.plankType.toString());
        }
        tags.func_74768_a("plankMeta", this.plankMeta);
        NBTTagList storageTag = this.storage.serializeNBT();
        tags.func_74782_a("storage", (NBTBase)storageTag);
        return tags;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        if (this.plankColor == null) {
            this.recachePlankColor();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        if (tags.func_74764_b("linens")) {
            this.linens.deserializeNBT(tags.func_74775_l("linens"));
        }
        if (tags.func_74764_b("blankets")) {
            this.linens.setBlankets(ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("blankets")));
        }
        if (tags.func_74764_b("sheets")) {
            this.linens.setSheets(ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("sheets")));
        }
        if (tags.func_74764_b("plankColor")) {
            this.plankColor = new Color(tags.func_74762_e("plankColor"));
        }
        this.plankType = new ResourceLocation(tags.func_74779_i("plankType"));
        this.plankMeta = tags.func_74762_e("plankMeta");
        if (tags.func_74764_b("storage")) {
            NBTTagList storageTags = tags.func_150295_c("storage", 10);
            this.storage.deserializeNBT(storageTags);
        }
        this.updateClients(Part.Type.BLANKETS);
        this.updateClients(Part.Type.SHEETS);
    }

    public NBTTagCompound getPlankData() {
        NBTTagCompound plankData = new NBTTagCompound();
        if (this.plankColor != null) {
            plankData.func_74768_a("color", this.plankColor.getRGB());
        }
        if (this.plankType != null) {
            plankData.func_74778_a("frameType", this.plankType.toString());
            plankData.func_74768_a("frameMeta", this.plankMeta);
        }
        return plankData;
    }

    public ResourceLocation getPlankType() {
        return this.plankType;
    }

    public int getPlankMeta() {
        return this.plankMeta;
    }

    public void setPlankType(NBTTagCompound nbt) throws FrameException {
        this.setPlankType(nbt, true);
    }

    public void setPlankType(NBTTagCompound nbt, boolean updateClients) throws FrameException {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("color")) {
            this.plankColor = new Color(nbt.func_74762_e("color"));
        }
        if (!nbt.func_74764_b("frameType")) {
            throw new FrameException("Need to have frame type set.");
        }
        if (!nbt.func_74764_b("frameMeta")) {
            throw new FrameException("Need to have frame meta set.");
        }
        ResourceLocation rl = new ResourceLocation(nbt.func_74779_i("frameType"));
        int meta = nbt.func_74762_e("frameMeta");
        this.setPlankType(rl, meta, updateClients);
    }

    public void setPlankType(ResourceLocation plankType, int plankMeta) throws FrameException {
        this.setPlankType(plankType, plankMeta, true);
    }

    public void setPlankType(ResourceLocation plankType, int plankMeta, boolean updateClients) throws FrameException {
        FrameWhitelistEntry entry = FrameRegistry.getFrameWhitelist(FrameRegistry.EnumFrameType.WOOD).getEntry(plankType);
        boolean valid = entry.isWhitelisted(plankMeta);
        if (!valid) {
            throw new FrameException("Not a valid frame type");
        }
        this.plankType = plankType;
        this.plankMeta = plankMeta;
        if (updateClients && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BedFrameUpdate update = new BedFrameUpdate(this.field_174879_c, this.plankType, this.plankMeta);
            BedCraftBeyond.NETWORK.sendToAllAround((IMessage)update, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 25.0));
        }
        if (this.field_145850_b.field_72995_K && this.plankColor == null) {
            this.plankColor = FrameHelper.getColorFromPlankType(this.plankType, this.plankMeta);
        }
        this.func_70296_d();
    }

    public Color getPlankColor() {
        if (this.field_145850_b.field_72995_K && this.plankColor == null) {
            this.recachePlankColor();
        }
        return this.plankColor != null ? this.plankColor : Color.WHITE;
    }

    public void recachePlankColor() {
        this.plankColor = FrameHelper.getColorFromPlankType(this.plankType, this.plankMeta);
    }

    @Override
    public LinenHandler getLinenHandler() {
        return this.linens;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity pack = super.func_189518_D_();
        return pack;
    }

    public final void updateClients(Part.Type part) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_70296_d();
        switch (part) {
            case BLANKETS: 
            case SHEETS: {
                LinenUpdate update = new LinenUpdate(this.field_174879_c, part, this.linens.getLinenPart(part, false));
                BedCraftBeyond.NETWORK.sendToAllAround((IMessage)update, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 25.0));
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityStorageHandler.INSTANCE && facing.func_176736_b() != -1) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityStorageHandler.INSTANCE) {
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                return null;
            }
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class DrawerStorage
    extends StorageHandler {
        public DrawerStorage() {
            this.registeredSlots = ImmutableList.of((Object)"head", (Object)"foot");
        }
    }
}

