/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.linens;

import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import zornco.bedcraftbeyond.linens.PropertyFabricType;
import zornco.bedcraftbeyond.linens.impl.ItemBlanket;
import zornco.bedcraftbeyond.linens.impl.ItemSheets;
import zornco.bedcraftbeyond.parts.IColorablePart;
import zornco.bedcraftbeyond.parts.IPart;
import zornco.bedcraftbeyond.parts.Part;

public class LinenHandler
extends ItemStackHandler {
    public LinenHandler() {
        super(2);
    }

    public ItemStack getSheets() {
        return this.getStackInSlot(0);
    }

    public ItemStack getBlankets() {
        return this.getStackInSlot(1);
    }

    public void setSheets(ItemStack stack) {
        this.setStackInSlot(0, stack);
    }

    public void setBlankets(ItemStack stack) {
        this.setStackInSlot(1, stack);
    }

    public boolean hasBothParts() {
        return this.hasLinenPart(Part.Type.SHEETS) && this.hasLinenPart(Part.Type.BLANKETS);
    }

    public PropertyFabricType getLinenType(Part.Type type) {
        if (!type.isLinenPart()) {
            return PropertyFabricType.NONE;
        }
        ItemStack part = this.getLinenPart(type, false);
        if (part == null) {
            return PropertyFabricType.NONE;
        }
        if (!part.func_77942_o()) {
            part.func_77982_d(new NBTTagCompound());
        }
        if (!part.func_77978_p().func_74764_b("type")) {
            part.func_77978_p().func_74778_a("type", PropertyFabricType.NONE.name());
            return PropertyFabricType.NONE;
        }
        try {
            return PropertyFabricType.valueOf(part.func_77978_p().func_74779_i("type"));
        }
        catch (Exception e) {
            return PropertyFabricType.NONE;
        }
    }

    public Color getLinenColor(Part.Type type) {
        ItemStack i = this.getLinenPart(type, false);
        if (i == null) {
            Color.WHITE.getRGB();
        }
        if (this.getLinenType(type) != PropertyFabricType.SOLID_COLOR) {
            return Color.WHITE;
        }
        Part part = ((IPart)i.func_77973_b()).getPartReference();
        if (part instanceof IColorablePart.IColorableItem) {
            return ((IColorablePart.IColorableItem)((Object)part)).getPartColor(i);
        }
        return Color.WHITE;
    }

    public boolean hasLinenPart(Part.Type part) {
        switch (part) {
            case SHEETS: {
                return this.getStackInSlot(0) != null;
            }
            case BLANKETS: {
                return this.getStackInSlot(1) != null;
            }
        }
        return false;
    }

    public ItemStack getLinenPart(Part.Type part, boolean extract) {
        switch (part) {
            case SHEETS: {
                return this.extractItem(0, 1, !extract);
            }
            case BLANKETS: {
                return this.extractItem(1, 1, !extract);
            }
        }
        return null;
    }

    public boolean setLinenPart(Part.Type part, ItemStack linen) {
        ItemStack inserted;
        if (linen == null || linen.func_77973_b() == null) {
            return false;
        }
        ItemStack linenCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)linen, (int)1);
        int slot = 0;
        switch (part) {
            case SHEETS: {
                if (!(linenCopy.func_77973_b() instanceof ItemSheets)) {
                    return false;
                }
                slot = 0;
                break;
            }
            case BLANKETS: {
                if (!(linenCopy.func_77973_b() instanceof ItemBlanket)) {
                    return false;
                }
                slot = 1;
            }
        }
        return this.getStackInSlot(slot) == null && (inserted = this.insertItem(slot, linenCopy, false)) == null;
    }
}

