/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.linens;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.linens.ILinenHolder;
import zornco.bedcraftbeyond.parts.Part;

public class LinenUpdate
implements IMessage {
    private BlockPos pos;
    private Part.Type part;
    private ItemStack partItem;

    public LinenUpdate() {
    }

    public LinenUpdate(BlockPos pos, Part.Type part, ItemStack partItem) {
        this.pos = pos;
        this.part = part;
        this.partItem = partItem;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        this.part = Part.Type.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.partItem = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)this.pos));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.part.name());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.partItem);
    }

    public static class Handler
    implements IMessageHandler<LinenUpdate, IMessage> {
        public IMessage onMessage(LinenUpdate message, MessageContext ctx) {
            World w = BedCraftBeyond.PROXY.getClientWorld();
            IBlockState curState = w.func_180495_p(message.pos);
            TileEntity tile = w.func_175625_s(message.pos);
            if (tile == null || !(tile instanceof ILinenHolder)) {
                return null;
            }
            ((ILinenHolder)tile).getLinenHandler().setLinenPart(message.part, message.partItem);
            IBlockState newState = w.func_180495_p(message.pos).func_185899_b((IBlockAccess)w, message.pos);
            w.func_184138_a(message.pos, curState, newState, 2);
            return null;
        }
    }
}

