/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.rugs;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.ModContent;

public class BlockRug
extends Block {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);

    public BlockRug() {
        super(Material.field_151580_n);
        this.func_149711_c(0.8f);
        this.func_149663_c("bedcraftbeyond.rug");
        this.setRegistryName("bedcraftbeyond", "rug_block");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.STRAIGHT)));
        this.func_149647_a(BedCraftBeyond.MAIN_TAB);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        switch ((EnumShape)((Object)state.func_177229_b(SHAPE))) {
            case STRAIGHT: 
            case INNER_LEFT: 
            case INNER_RIGHT: 
            case OUTER_LEFT: 
            case OUTER_RIGHT: {
                return new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, -0.4375, 1.0);
            }
            case BLOCK: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
            }
            case SLAB: {
                return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 0.5625, 1.0);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) return true;
        if (!BlockRug.isBlockValid(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) return true;
        if (!BlockRug.isBlockValid(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) return false;
        return true;
    }

    public static boolean isBlockValid(Block block) {
        return block instanceof BlockStairs || block instanceof BlockSlab;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.DOWN) || !BlockRug.isBlockValid(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public static boolean canConnectRugTo(IBlockAccess par1IBlockAccess, BlockPos pos) {
        Block var5 = par1IBlockAccess.func_180495_p(pos).func_177230_c();
        return var5 == ModContent.Blocks.stoneBed && !par1IBlockAccess.func_175623_d(pos);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    public static int getBlockFromDye(int par0) {
        return ~par0 & 0xF;
    }

    public static int getDyeFromBlock(int par0) {
        return ~par0 & 0xF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176768_e();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177977_b());
        Block underBlock = underState.func_177230_c();
        underState = underBlock.func_176221_a(underState, worldIn, pos.func_177977_b());
        if (underBlock instanceof BlockStairs && underState.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM) {
            state = state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.getShape((BlockStairs.EnumShape)underState.func_177229_b((IProperty)BlockStairs.field_176310_M))));
            state = state.func_177226_a((IProperty)FACING, underState.func_177229_b((IProperty)FACING));
        } else {
            state = underBlock instanceof BlockSlab && underState.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM ? state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.SLAB)) : state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.BLOCK));
        }
        if (state.func_177229_b(SHAPE) == EnumShape.SLAB) {
            // empty if block
        }
        return state;
    }

    private IBlockState applyLowerState(IBlockState state, IBlockAccess worldIn, BlockPos pos, PropertyEnum<EnumSideHalf> side, EnumFacing facing) {
        IBlockState sideState = worldIn.func_180495_p(pos);
        Block sideBlock = sideState.func_177230_c();
        sideState = sideBlock.func_176221_a(sideState, worldIn, pos);
        if (sideBlock instanceof BlockRug) {
            if (sideState.func_177229_b(SHAPE) == EnumShape.BLOCK) {
                state = state.func_177226_a(side, (Comparable)((Object)EnumSideHalf.HALF));
            } else if (sideState.func_177229_b(SHAPE) == EnumShape.STRAIGHT) {
                EnumSideHalf apply = EnumSideHalf.NONE;
                block0 : switch (facing) {
                    case EAST: {
                        switch ((EnumFacing)sideState.func_177229_b((IProperty)FACING)) {
                            case SOUTH: {
                                apply = EnumSideHalf.RIGHT;
                                break block0;
                            }
                            case WEST: {
                                apply = EnumSideHalf.HALF;
                                break block0;
                            }
                            case NORTH: {
                                apply = EnumSideHalf.LEFT;
                                break block0;
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch ((EnumFacing)sideState.func_177229_b((IProperty)FACING)) {
                            case EAST: {
                                apply = EnumSideHalf.LEFT;
                                break block0;
                            }
                            case WEST: {
                                apply = EnumSideHalf.RIGHT;
                                break block0;
                            }
                            case NORTH: {
                                apply = EnumSideHalf.HALF;
                                break block0;
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch ((EnumFacing)sideState.func_177229_b((IProperty)FACING)) {
                            case EAST: {
                                apply = EnumSideHalf.HALF;
                                break block0;
                            }
                            case SOUTH: {
                                apply = EnumSideHalf.LEFT;
                                break block0;
                            }
                            case WEST: {
                                apply = EnumSideHalf.HALF;
                                break block0;
                            }
                            case NORTH: {
                                apply = EnumSideHalf.RIGHT;
                                break block0;
                            }
                        }
                        break;
                    }
                    case NORTH: {
                        switch ((EnumFacing)sideState.func_177229_b((IProperty)FACING)) {
                            case EAST: {
                                apply = EnumSideHalf.RIGHT;
                                break block0;
                            }
                            case SOUTH: {
                                apply = EnumSideHalf.HALF;
                                break block0;
                            }
                            case WEST: {
                                apply = EnumSideHalf.LEFT;
                                break block0;
                            }
                        }
                        break;
                    }
                }
                state = state.func_177226_a(side, (Comparable)((Object)apply));
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR, FACING, SHAPE});
    }

    public static enum EnumShape implements IStringSerializable
    {
        BLOCK("block"),
        SLAB("slab"),
        STRAIGHT("straight"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private EnumShape(String name) {
            this.name = name;
        }

        public static EnumShape getShape(BlockStairs.EnumShape shape) {
            switch (shape) {
                case STRAIGHT: {
                    return STRAIGHT;
                }
                case INNER_LEFT: {
                    return INNER_LEFT;
                }
                case INNER_RIGHT: {
                    return INNER_RIGHT;
                }
                case OUTER_LEFT: {
                    return OUTER_LEFT;
                }
                case OUTER_RIGHT: {
                    return OUTER_RIGHT;
                }
            }
            return STRAIGHT;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumSideHalf implements IStringSerializable
    {
        HALF("half"),
        LEFT("left"),
        RIGHT("right"),
        FULL("full"),
        NONE("none");

        private final String name;

        private EnumSideHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

