/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.storage.handling;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.storage.handling.CapabilityStorageHandler;
import zornco.bedcraftbeyond.storage.handling.IStorageHandler;
import zornco.bedcraftbeyond.storage.handling.StoragePacketHandler;

public class MessageOpenStorage
implements IMessage {
    protected EntityPlayer player;
    protected IStorageHandler handler;
    protected BlockPos tilePos;
    protected EnumFacing side;
    protected String storageID;
    protected int windowID;

    public MessageOpenStorage() {
    }

    public MessageOpenStorage(EntityPlayer player, BlockPos tilePos, EnumFacing side, IStorageHandler handler, String id) {
        this.player = player;
        this.tilePos = tilePos;
        this.side = side;
        this.handler = handler;
        this.storageID = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.tilePos = BlockPos.func_177969_a((long)buf.readLong());
        this.storageID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.side = EnumFacing.func_82600_a((int)buf.readInt());
        this.windowID = buf.readInt();
        World w = BedCraftBeyond.PROXY.getClientWorld();
        TileEntity te = w.func_175625_s(this.tilePos);
        if (te == null) {
            return;
        }
        if (!te.hasCapability(CapabilityStorageHandler.INSTANCE, this.side)) {
            return;
        }
        this.handler = (IStorageHandler)te.getCapability(CapabilityStorageHandler.INSTANCE, this.side);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.tilePos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.storageID);
        buf.writeInt(this.side.func_176745_a());
        buf.writeInt(((EntityPlayerMP)this.player).field_71139_cq);
    }

    public static class Handler
    implements IMessageHandler<MessageOpenStorage, IMessage> {
        public IMessage onMessage(MessageOpenStorage message, MessageContext ctx) {
            EntityPlayer player = BedCraftBeyond.PROXY.getPlayer();
            StoragePacketHandler.openStorage(player.field_70170_p, player, message.tilePos, message.side, message.handler, message.storageID);
            player.field_71070_bA.field_75152_c = message.windowID;
            return null;
        }
    }
}

