/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.storage.handling;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.storage.handling.CapabilityStorageHandler;
import zornco.bedcraftbeyond.storage.handling.IStorageHandler;

public class MessageStorageUpdate
implements IMessage {
    protected BlockPos pos;
    protected String slot;
    protected EnumFacing side;
    protected ItemStack stack;

    public MessageStorageUpdate() {
    }

    public MessageStorageUpdate(BlockPos pos, String slot, EnumFacing side, @Nullable ItemStack stack) {
        this.pos = pos;
        this.slot = slot;
        this.side = side;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.slot = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.side = EnumFacing.func_82600_a((int)buf.readInt());
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.slot);
        buf.writeInt(this.side.func_176745_a());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<MessageStorageUpdate, IMessage> {
        public IMessage onMessage(MessageStorageUpdate message, MessageContext ctx) {
            World w = BedCraftBeyond.PROXY.getClientWorld();
            TileEntity te = w.func_175625_s(message.pos);
            if (!te.hasCapability(CapabilityStorageHandler.INSTANCE, message.side)) {
                return null;
            }
            IStorageHandler handler = (IStorageHandler)te.getCapability(CapabilityStorageHandler.INSTANCE, message.side);
            handler.setNamedSlot(message.slot, message.stack);
            return null;
        }
    }
}

