/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.storage.handling;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import zornco.bedcraftbeyond.parts.Part;
import zornco.bedcraftbeyond.storage.StoragePart;
import zornco.bedcraftbeyond.storage.handling.IStorageHandler;

public class StorageHandler
implements IStorageHandler,
INBTSerializable<NBTTagList> {
    protected ImmutableList<String> registeredSlots = ImmutableList.of((Object)"default");
    private HashMap<String, ItemStack> storage = new HashMap();

    @Override
    public IItemHandler getSlotItemHandler(String name) {
        if (!this.hasSlotWithName(name) || !this.storage.containsKey(name)) {
            return null;
        }
        return (IItemHandler)this.storage.get(name).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    @Override
    public ItemStack getSlotItemStack(String name, boolean extract) {
        if (!this.hasSlotWithName(name)) {
            return null;
        }
        ItemStack stack = this.storage.get(name).func_77946_l();
        if (extract) {
            this.storage.remove(name);
        }
        return stack;
    }

    @Override
    public boolean hasSlotWithName(String name) {
        return this.registeredSlots.contains((Object)name);
    }

    @Override
    public boolean setNamedSlot(String name, ItemStack stack) {
        if (!this.hasSlotWithName(name)) {
            return false;
        }
        if (Part.getPartType(stack) != Part.Type.STORAGE) {
            return false;
        }
        if (!(Part.getPartReference(stack) instanceof StoragePart)) {
            return false;
        }
        if (!stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return false;
        }
        this.storage.remove(name);
        this.storage.put(name, stack);
        return true;
    }

    @Override
    public boolean isSlotFilled(String name) {
        return this.storage.containsKey(name);
    }

    @Override
    public ImmutableList<String> getSlotNames() {
        return this.registeredSlots;
    }

    @Override
    public ItemStack fillSlot(String slotName, ItemStack stack) {
        if (!this.registeredSlots.contains((Object)slotName)) {
            return stack.func_77946_l();
        }
        if (this.isSlotFilled(slotName)) {
            return stack.func_77946_l();
        }
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        if (!this.setNamedSlot(slotName, copy)) {
            return stack.func_77946_l();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - 1));
    }

    @Override
    public StoragePart getSlotPart(String storageID) {
        if (!this.hasSlotWithName(storageID)) {
            return null;
        }
        if (!this.isSlotFilled(storageID)) {
            return null;
        }
        return (StoragePart)Part.getPartReference(this.storage.get(storageID));
    }

    @Override
    public ImmutableList<ItemStack> getItems() {
        return ImmutableList.copyOf(this.storage.values());
    }

    public NBTTagList serializeNBT() {
        NBTTagList compound = new NBTTagList();
        for (Map.Entry<String, ItemStack> part : this.storage.entrySet()) {
            IItemHandler itemHandler = (IItemHandler)part.getValue().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            NBTTagCompound storageTag = new NBTTagCompound();
            storageTag.func_74778_a("name", part.getKey());
            storageTag.func_74768_a("size", itemHandler.getSlots());
            storageTag.func_74782_a("item", (NBTBase)part.getValue().serializeNBT());
            compound.func_74742_a((NBTBase)storageTag);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagList nbt) {
        if (nbt.func_82582_d()) {
            return;
        }
        for (int storageIndex = 0; storageIndex < nbt.func_74745_c(); ++storageIndex) {
            NBTTagCompound itemsAt = nbt.func_150305_b(storageIndex);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemsAt.func_74775_l("item"));
            this.setNamedSlot(itemsAt.func_74779_i("name"), item);
        }
    }
}

