/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.client;

import dmillerw.ping.data.PingType;
import dmillerw.ping.data.PingWrapper;
import dmillerw.ping.helper.PingRenderHelper;
import dmillerw.ping.misc.PingSounds;
import dmillerw.ping.network.packet.ServerBroadcastPing;
import dmillerw.ping.proxy.ClientProxy;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class PingHandler {
    public static final PingHandler INSTANCE = new PingHandler();
    public static final ResourceLocation TEXTURE = new ResourceLocation("ping:textures/ping.png");
    private final List<PingWrapper> activePings = new ArrayList<PingWrapper>();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public void onPingPacket(ServerBroadcastPing packet) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_70011_f((double)packet.ping.pos.func_177958_n(), (double)packet.ping.pos.func_177956_o(), (double)packet.ping.pos.func_177952_p()) <= ClientProxy.pingAcceptDistance) {
            if (ClientProxy.sound) {
                mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(PingSounds.bloop, SoundCategory.PLAYERS, 0.25f, 1.0f, (float)packet.ping.pos.func_177958_n(), (float)packet.ping.pos.func_177956_o(), (float)packet.ping.pos.func_177952_p()));
            }
            packet.ping.timer = ClientProxy.pingDuration;
            this.activePings.add(packet.ping);
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderEntity = mc.func_175606_aa();
        double interpX = renderEntity.field_70169_q + (renderEntity.field_70165_t - renderEntity.field_70169_q) * (double)event.getPartialTicks();
        double interpY = renderEntity.field_70167_r + (renderEntity.field_70163_u - renderEntity.field_70167_r) * (double)event.getPartialTicks();
        double interpZ = renderEntity.field_70166_s + (renderEntity.field_70161_v - renderEntity.field_70166_s) * (double)event.getPartialTicks();
        Frustum camera = new Frustum();
        camera.func_78547_a(interpX, interpY, interpZ);
        for (PingWrapper ping : this.activePings) {
            double px = (double)ping.pos.func_177958_n() + 0.5 - interpX;
            double py = (double)ping.pos.func_177956_o() + 0.5 - interpY;
            double pz = (double)ping.pos.func_177952_p() + 0.5 - interpZ;
            if (camera.func_78546_a(ping.getAABB())) {
                ping.isOffscreen = false;
                if (ClientProxy.blockOverlay) {
                    this.renderPingOverlay((double)ping.pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b, (double)ping.pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c, (double)ping.pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d, ping);
                }
                this.renderPing(px, py, pz, renderEntity, ping);
                continue;
            }
            ping.isOffscreen = true;
            this.translatePingCoordinates(px, py, pz, ping);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            for (PingWrapper ping : this.activePings) {
                if (!ping.isOffscreen) continue;
                int width = mc.field_71443_c;
                int height = mc.field_71440_d;
                int x1 = -(width / 2) + 32;
                int y1 = -(height / 2) + 32;
                int x2 = width / 2 - 32;
                int y2 = height / 2 - 32;
                double pingX = ping.screenX;
                double pingY = ping.screenY;
                double angle = Math.atan2(pingY -= (double)(height / 2), pingX -= (double)(width / 2));
                double cos = Math.cos(angle += Math.toRadians(90.0));
                double sin = Math.sin(angle);
                double m = cos / sin;
                if (cos > 0.0) {
                    pingX = (double)y2 / m;
                    pingY = y2;
                } else {
                    pingX = (double)y1 / m;
                    pingY = y1;
                }
                if (pingX > (double)x2) {
                    pingX = x2;
                    pingY = (double)x2 * m;
                } else if (pingX < (double)x1) {
                    pingX = x1;
                    pingY = (double)x1 * m;
                }
                GlStateManager.func_179094_E();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer vertexbuffer = tessellator.func_178180_c();
                vertexbuffer.func_178969_c((pingX += (double)(width / 2)) / 2.0, (pingY += (double)(height / 2)) / 2.0, 0.0);
                float min = -8.0f;
                float max = 8.0f;
                int alpha = ping.type == PingType.ALERT ? (int)((double)1.3f + Math.sin(mc.field_71441_e.func_72820_D())) : 1;
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int r = ping.color >> 16 & 0xFF;
                int g = ping.color >> 8 & 0xFF;
                int b = ping.color & 0xFF;
                vertexbuffer.func_181662_b((double)min, (double)max, 0.0).func_187315_a((double)PingType.BACKGROUND.minU, (double)PingType.BACKGROUND.maxV).func_181669_b(r, g, b, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)max, (double)max, 0.0).func_187315_a((double)PingType.BACKGROUND.maxU, (double)PingType.BACKGROUND.maxV).func_181669_b(r, g, b, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)max, (double)min, 0.0).func_187315_a((double)PingType.BACKGROUND.maxU, (double)PingType.BACKGROUND.minV).func_181669_b(r, g, b, 255).func_181675_d();
                vertexbuffer.func_181662_b((double)min, (double)min, 0.0).func_187315_a((double)PingType.BACKGROUND.minU, (double)PingType.BACKGROUND.minV).func_181669_b(r, g, b, 255).func_181675_d();
                tessellator.func_78381_a();
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                vertexbuffer.func_181662_b((double)min, (double)max, 0.0).func_187315_a((double)ping.type.minU, (double)ping.type.maxV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
                vertexbuffer.func_181662_b((double)max, (double)max, 0.0).func_187315_a((double)ping.type.maxU, (double)ping.type.maxV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
                vertexbuffer.func_181662_b((double)max, (double)min, 0.0).func_187315_a((double)ping.type.maxU, (double)ping.type.minV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
                vertexbuffer.func_181662_b((double)min, (double)min, 0.0).func_187315_a((double)ping.type.minU, (double)ping.type.minV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
                tessellator.func_78381_a();
                vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Iterator<PingWrapper> iterator = this.activePings.iterator();
        while (iterator.hasNext()) {
            PingWrapper pingWrapper = iterator.next();
            if (pingWrapper.animationTimer > 0) {
                pingWrapper.animationTimer -= 5;
            }
            --pingWrapper.timer;
            if (pingWrapper.timer > 0) continue;
            iterator.remove();
        }
    }

    private void renderPing(double px, double py, double pz, Entity renderEntity, PingWrapper ping) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)px, (double)py, (double)pz);
        GlStateManager.func_179114_b((float)(-renderEntity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderEntity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        float min = -0.25f - 0.25f * (float)ping.animationTimer / 20.0f;
        float max = 0.25f + 0.25f * (float)ping.animationTimer / 20.0f;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        int r = ping.color >> 16 & 0xFF;
        int g = ping.color >> 8 & 0xFF;
        int b = ping.color & 0xFF;
        vertexbuffer.func_181662_b((double)min, (double)max, 0.0).func_187315_a((double)PingType.BACKGROUND.minU, (double)PingType.BACKGROUND.maxV).func_181669_b(r, g, b, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)max, (double)max, 0.0).func_187315_a((double)PingType.BACKGROUND.maxU, (double)PingType.BACKGROUND.maxV).func_181669_b(r, g, b, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)max, (double)min, 0.0).func_187315_a((double)PingType.BACKGROUND.maxU, (double)PingType.BACKGROUND.minV).func_181669_b(r, g, b, 255).func_181675_d();
        vertexbuffer.func_181662_b((double)min, (double)min, 0.0).func_187315_a((double)PingType.BACKGROUND.minU, (double)PingType.BACKGROUND.minV).func_181669_b(r, g, b, 255).func_181675_d();
        tessellator.func_78381_a();
        int alpha = ping.type == PingType.ALERT ? (int)((double)1.3f + Math.sin(Minecraft.func_71410_x().field_71441_e.func_72820_D())) : 175;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b((double)min, (double)max, 0.0).func_187315_a((double)ping.type.minU, (double)ping.type.maxV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
        vertexbuffer.func_181662_b((double)max, (double)max, 0.0).func_187315_a((double)ping.type.maxU, (double)ping.type.maxV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
        vertexbuffer.func_181662_b((double)max, (double)min, 0.0).func_187315_a((double)ping.type.maxU, (double)ping.type.minV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
        vertexbuffer.func_181662_b((double)min, (double)min, 0.0).func_187315_a((double)ping.type.minU, (double)ping.type.minV).func_181666_a(1.0f, 1.0f, 1.0f, (float)alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderPingOverlay(double x, double y, double z, PingWrapper ping) {
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack((Block)Blocks.field_150399_cn)).func_177554_e();
        float padding = 0.0f + 0.2f * (float)ping.animationTimer / 20.0f;
        float box = 1.0f + padding + padding;
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        PingRenderHelper.drawBlockOverlay(box, box, box, icon, ping.color, 175);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void translatePingCoordinates(double px, double py, double pz, PingWrapper ping) {
        FloatBuffer screenCoords = BufferUtils.createFloatBuffer((int)4);
        IntBuffer viewport = BufferUtils.createIntBuffer((int)16);
        FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
        FloatBuffer projection = BufferUtils.createFloatBuffer((int)16);
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)modelView);
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)projection);
        GL11.glGetInteger((int)2978, (IntBuffer)viewport);
        if (GLU.gluProject((float)((float)px), (float)((float)py), (float)((float)pz), (FloatBuffer)modelView, (FloatBuffer)projection, (IntBuffer)viewport, (FloatBuffer)screenCoords)) {
            ping.screenX = screenCoords.get(0);
            ping.screenY = screenCoords.get(1);
        }
    }
}

