/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.client;

import dmillerw.ping.client.PingHandler;
import dmillerw.ping.client.gui.GuiPingSelect;
import dmillerw.ping.data.PingType;
import dmillerw.ping.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class RenderHandler {
    public static final int ITEM_PADDING = 10;
    public static final int ITEM_SIZE = 32;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new RenderHandler());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if ((mc.field_71441_e == null || mc.func_147113_T()) && GuiPingSelect.active) {
                GuiPingSelect.deactivate();
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (!(event instanceof RenderGameOverlayEvent.Post) || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !mc.field_71474_y.field_74319_N && !mc.func_147113_T() && GuiPingSelect.active) {
            this.renderGui(event.getResolution());
            this.renderText(event.getResolution());
        }
    }

    private void renderGui(ScaledResolution resolution) {
        int numOfItems = PingType.values().length - 1;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        if (ClientProxy.menuBackground) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            float halfWidth = 32 * numOfItems - 10 * numOfItems;
            float halfHeight = 21.0f;
            float backgroundX = (float)(resolution.func_78326_a() / 2) - halfWidth;
            float backgroundY = (float)(resolution.func_78328_b() / 4) - halfHeight;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b((double)backgroundX, (double)(backgroundY + 15.0f + halfHeight * 2.0f), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            vertexbuffer.func_181662_b((double)(backgroundX + halfWidth * 2.0f), (double)(backgroundY + 15.0f + halfHeight * 2.0f), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            vertexbuffer.func_181662_b((double)(backgroundX + halfWidth * 2.0f), (double)backgroundY, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            vertexbuffer.func_181662_b((double)backgroundX, (double)backgroundY, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PingHandler.TEXTURE);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        float half = numOfItems / 2;
        for (int i = 0; i < numOfItems; ++i) {
            PingType type = PingType.values()[i + 1];
            float drawX = (float)(resolution.func_78326_a() / 2) - 32.0f * half - 10.0f * half;
            float drawY = resolution.func_78328_b() / 4;
            boolean mouseIn = (float)mouseX >= (drawX += (float)(21 + 10 * i + 32 * i)) - 16.0f && (float)mouseX <= drawX + 16.0f && (float)mouseY >= drawY - 16.0f && (float)mouseY <= drawY + 16.0f;
            float min = -16.0f;
            float max = 16.0f;
            int r = 255;
            int g = 255;
            int b = 255;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            if (mouseIn) {
                r = ClientProxy.pingR;
                g = ClientProxy.pingG;
                b = ClientProxy.pingB;
            }
            vertexbuffer.func_181662_b((double)(drawX + min), (double)(drawY + max), 0.0).func_187315_a((double)PingType.BACKGROUND.minU, (double)PingType.BACKGROUND.maxV).func_181669_b(r, g, b, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)(drawX + max), (double)(drawY + max), 0.0).func_187315_a((double)PingType.BACKGROUND.maxU, (double)PingType.BACKGROUND.maxV).func_181669_b(r, g, b, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)(drawX + max), (double)(drawY + min), 0.0).func_187315_a((double)PingType.BACKGROUND.maxU, (double)PingType.BACKGROUND.minV).func_181669_b(r, g, b, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)(drawX + min), (double)(drawY + min), 0.0).func_187315_a((double)PingType.BACKGROUND.minU, (double)PingType.BACKGROUND.minV).func_181669_b(r, g, b, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexbuffer.func_181662_b((double)(drawX + min), (double)(drawY + max), 0.0).func_187315_a((double)type.minU, (double)type.maxV).func_181669_b(255, 255, 255, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)(drawX + max), (double)(drawY + max), 0.0).func_187315_a((double)type.maxU, (double)type.maxV).func_181669_b(255, 255, 255, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)(drawX + max), (double)(drawY + min), 0.0).func_187315_a((double)type.maxU, (double)type.minV).func_181669_b(255, 255, 255, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)(drawX + min), (double)(drawY + min), 0.0).func_187315_a((double)type.minU, (double)type.minV).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private void renderText(ScaledResolution resolution) {
        Minecraft mc = Minecraft.func_71410_x();
        int numOfItems = PingType.values().length - 1;
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int mouseX = Mouse.getX() * width / mc.field_71443_c;
        int mouseY = height - Mouse.getY() * height / mc.field_71440_d - 1;
        float halfWidth = 32 * numOfItems - 10 * numOfItems;
        float halfHeight = 21.0f;
        float backgroundX = (float)(resolution.func_78326_a() / 2) - halfWidth;
        float backgroundY = (float)(resolution.func_78328_b() / 4) - halfHeight;
        float half = numOfItems / 2;
        for (int i = 0; i < numOfItems; ++i) {
            boolean mouseIn;
            PingType type = PingType.values()[i + 1];
            float drawX = (float)(resolution.func_78326_a() / 2) - 32.0f * half - 10.0f * half;
            float drawY = resolution.func_78328_b() / 4;
            boolean bl = mouseIn = (float)mouseX >= (drawX += (float)(21 + 10 * i + 32 * i)) - 16.0f && (float)mouseX <= drawX + 16.0f && (float)mouseY >= drawY - 16.0f && (float)mouseY <= drawY + 16.0f;
            if (!mouseIn) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
            mc.field_71466_p.func_78276_b(type.toString(), resolution.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(type.toString()) / 2, (int)(backgroundY + halfHeight * 2.0f), 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
    }
}

