/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveTile;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.api.farming.FarmDirection;
import forestry.api.genetics.IChromosomeType;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.tiles.TileApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.Fluids;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEngine;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.GeneticsUtil;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileRaintank;
import forestry.factory.tiles.TileStill;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import io.github.drmanganese.topaddons.TOPRegistrar;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.ItemArmorProbed;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.elements.forestry.ElementBeeHousingInventory;
import io.github.drmanganese.topaddons.elements.forestry.ElementForestryFarm;
import io.github.drmanganese.topaddons.helmets.forestry.ItemProbedApiaristArmor;
import io.github.drmanganese.topaddons.helmets.forestry.ItemProbedArmorNaturalist;
import io.github.drmanganese.topaddons.reference.Colors;
import io.github.drmanganese.topaddons.reference.Names;
import io.github.drmanganese.topaddons.styles.ProgressStyleForestryMultiColored;
import java.util.Arrays;
import java.util.List;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

@TOPAddon(dependency="forestry")
public class AddonForestry
extends AddonBlank {
    public static int ELEMENT_FARM;
    public static int ELEMENT_BEE_INV;
    private final List<IErrorState> NORMAL_STATES = Arrays.asList(EnumErrorCode.NO_QUEEN, EnumErrorCode.IS_RAINING, EnumErrorCode.NOT_DAY, EnumErrorCode.FORCED_COOLDOWN, EnumErrorCode.NO_SPECIMEN, EnumErrorCode.NOT_DARK);

    @Override
    public boolean hasHelmets() {
        return true;
    }

    @Override
    public List<Class<? extends ItemArmorProbed>> getHelmets() {
        return Arrays.asList(ItemProbedApiaristArmor.class, ItemProbedArmorNaturalist.class);
    }

    @Override
    public void registerElements() {
        ELEMENT_FARM = TOPRegistrar.GetTheOneProbe.probe.registerElementFactory(ElementForestryFarm::new);
        ELEMENT_BEE_INV = TOPRegistrar.GetTheOneProbe.probe.registerElementFactory(ElementBeeHousingInventory::new);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile;
        if (blockState.func_177230_c() == PluginCore.blocks.bogEarth) {
            probeInfo.text(TextFormatting.GREEN + "Maturity: " + (Integer)blockState.func_177229_b((IProperty)BlockBogEarth.MATURITY) * 100 / 3 + "%");
        }
        if ((tile = world.func_175625_s(data.getPos())) != null && (tile instanceof TileForestry || tile instanceof TileAlveary || tile instanceof TileTreeContainer || tile instanceof TileFarm)) {
            int i;
            TileAnalyzer analyzer;
            ImmutableSet errorStates = tile instanceof IErrorLogicSource ? ((IErrorLogicSource)tile).getErrorLogic().getErrorStates() : ImmutableSet.of();
            if (tile instanceof IBeeHousing && !(tile instanceof IHiveTile)) {
                IBeeHousing beeHousing = (IBeeHousing)tile;
                ItemStack queen = beeHousing.getBeeInventory().getQueen();
                if (queen != null) {
                    int progress = beeHousing.getBeekeepingLogic().getBeeProgressPercent();
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(queen).progress(progress, 100, (IProgressStyle)new ProgressStyleForestryMultiColored(progress).showText(false));
                    if (mode == ProbeMode.EXTENDED) {
                        probeInfo.text(TextFormatting.YELLOW + "Species: " + TextFormatting.WHITE + BeeManager.beeRoot.getMember(queen).getGenome().getSpeciesRoot().getMember(queen).getDisplayName());
                    }
                }
                if (mode == ProbeMode.EXTENDED) {
                    ItemStack stack;
                    int i2;
                    ItemStack[] inventoryStacks = new ItemStack[tile instanceof TileApiary ? 12 : 9];
                    if (tile instanceof TileAlveary) {
                        for (i2 = 0; i2 < 9; ++i2) {
                            stack = ((MultiblockLogicAlveary)((TileAlveary)tile).getMultiblockLogic()).getController().getInternalInventory().func_70301_a(i2);
                            inventoryStacks[i2] = stack != null ? stack : new ItemStack(Blocks.field_180401_cv);
                        }
                    } else if (tile instanceof TileBeeHousingBase) {
                        for (i2 = 0; i2 < 9; ++i2) {
                            stack = ((TileBeeHousingBase)tile).getInternalInventory().func_70301_a(i2);
                            inventoryStacks[i2] = stack != null ? stack : new ItemStack(Blocks.field_180401_cv);
                        }
                        if (tile instanceof TileApiary) {
                            for (i2 = 9; i2 < 12; ++i2) {
                                stack = ((TileApiary)tile).getInternalInventory().func_70301_a(i2);
                                inventoryStacks[i2] = stack != null ? stack : new ItemStack(Blocks.field_180401_cv);
                            }
                        }
                    }
                    AddonForestry.addBeeHouseInventory(probeInfo, tile instanceof TileApiary, this.reorderBeeInvStacks(inventoryStacks));
                }
            }
            if (tile instanceof TileAnalyzer && (analyzer = (TileAnalyzer)tile).getIndividualOnDisplay() != null) {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(analyzer.getIndividualOnDisplay()).progress(analyzer.getProgressScaled(100), 100, (IProgressStyle)new ProgressStyleForestryMultiColored(analyzer.getProgressScaled(100)));
            }
            if (tile instanceof TileLeaves) {
                TileLeaves leaves = (TileLeaves)tile;
                if (leaves.hasFruit()) {
                    this.textPrefixed(probeInfo, "Fruit", leaves.getTree().getGenome().getFruitProvider().getDescription() + " - " + (leaves.getRipeness() >= 1.0f ? TextFormatting.GREEN + "Ripe" : TextFormatting.RED + "Unripe"));
                }
                if (leaves.isPollinated() && GeneticsUtil.hasNaturalistEye((EntityPlayer)player)) {
                    probeInfo.text(TextFormatting.GREEN + "Pollinated");
                }
            }
            if (tile instanceof TileSapling) {
                ITree tree = ((TileSapling)tile).getTree();
                if (mode == ProbeMode.EXTENDED) {
                    if (tree.isAnalyzed()) {
                        this.textPrefixed(probeInfo, "Saplings", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FERTILITY).getName());
                        this.textPrefixed(probeInfo, "Maturation", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.MATURATION).getName());
                        this.textPrefixed(probeInfo, "Height", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT).getName());
                        this.textPrefixed(probeInfo, "Girth", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.GIRTH).toString());
                        this.textPrefixed(probeInfo, "Yield", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD).getName());
                        this.textPrefixed(probeInfo, "Sappiness", tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS).getName());
                    } else {
                        probeInfo.text("Unknown Genome");
                    }
                }
            }
            if (tile instanceof TileFarm) {
                TileFarm farm = (TileFarm)tile;
                EnumFacing facing = player.func_174811_aO();
                ItemStack[] farmIcons = new ItemStack[5];
                ItemStack socket = ((MultiblockLogicFarm)farm.getMultiblockLogic()).getController().getSocket(0);
                farmIcons[4] = socket != null ? socket : new ItemStack(Blocks.field_180401_cv);
                for (int i3 = 0; i3 < 4; ++i3) {
                    farmIcons[i3] = ((MultiblockLogicFarm)farm.getMultiblockLogic()).getController().getFarmLogic(FarmDirection.getFarmDirection((EnumFacing)facing)).getIconItemStack();
                    facing = facing.func_176746_e();
                }
                if (mode == ProbeMode.NORMAL) {
                    AddonForestry.addFarmElement(probeInfo, farmIcons, facing.func_176746_e().func_176610_l().substring(0, 1).toUpperCase());
                }
                if (mode == ProbeMode.EXTENDED) {
                    ItemStack[] inventoryStacks = new ItemStack[20];
                    for (i = 0; i < 20; ++i) {
                        inventoryStacks[i] = farm.getInternalInventory().func_70301_a(i) == null ? new ItemStack(Blocks.field_180401_cv) : farm.getInternalInventory().func_70301_a(i);
                    }
                    AddonForestry.addFarmElement(probeInfo, farmIcons, facing.func_176746_e().func_176610_l().substring(0, 1).toUpperCase(), true, inventoryStacks);
                }
            }
            if (tile instanceof TileMoistener) {
                TileMoistener moistener = (TileMoistener)tile;
                int light = world.func_175699_k(data.getPos().func_177984_a());
                int speed = light > 11 ? 0 : (light >= 9 ? 1 : (light >= 7 ? 2 : (light >= 5 ? 3 : 4)));
                this.textPrefixed(probeInfo, "Speed", (speed == 0 ? TextFormatting.RED.toString() : "") + speed);
                ItemStack[] wheats = new ItemStack[]{new ItemStack(Items.field_151015_O, 0), new ItemStack((Item)PluginCore.items.mouldyWheat, 0), new ItemStack((Item)PluginCore.items.decayingWheat, 0), new ItemStack((Item)PluginCore.items.mulch, 0)};
                TextFormatting[] arrowColors = new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY, TextFormatting.DARK_GRAY};
                for (i = 0; i < 10; ++i) {
                    ItemStack stack = moistener.getInternalInventory().func_70301_a(i);
                    if (stack == null) continue;
                    for (int j = 0; j < wheats.length; ++j) {
                        if (!stack.func_77969_a(wheats[j])) continue;
                        wheats[j].field_77994_a += stack.field_77994_a;
                        if (i != 9) continue;
                        arrowColors[j] = TextFormatting.WHITE;
                    }
                }
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(wheats[0]).text(arrowColors[0] + "\u25b6").item(wheats[1]).text(arrowColors[1] + "\u25b6").item(wheats[2]).text(arrowColors[2] + "\u25b6").item(wheats[3]);
                if (moistener.getInternalInventory().func_70301_a(11) != null) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(moistener.getInternalInventory().func_70301_a(11)).progress(15 - moistener.getProductionProgressScaled(15), 15, probeInfo.defaultProgressStyle().showText(false)).item(moistener.getInternalInventory().func_70301_a(10));
                }
            }
            if (tile instanceof TileEngine) {
                TileEngine engine = (TileEngine)tile;
                if (mode == ProbeMode.EXTENDED) {
                    this.textPrefixed(probeInfo, "Stored", engine.getEnergyManager().getEnergyStored(null) + " RF");
                    this.textPrefixed(probeInfo, "Heat", engine.getHeat() / 10 + " C" + (errorStates.contains((Object)EnumErrorCode.FORCED_COOLDOWN) ? " (Cooling down)" : ""));
                }
                probeInfo.text(TextFormatting.GREEN + "Producing " + engine.getCurrentOutput() + " RF/t");
            }
            if (errorStates.size() > 0) {
                probeInfo.text(TextFormatting.RED + "Can't work");
                errorStates.forEach(state -> {
                    if (mode == ProbeMode.EXTENDED || this.NORMAL_STATES.contains(state)) {
                        probeInfo.text(TextFormatting.RED + "\u21aa " + I18n.func_74838_a((String)state.getUnlocalizedDescription()));
                    }
                });
            }
        }
    }

    @Override
    public void addFluidColors() {
        for (Fluids fluid : Fluids.values()) {
            Colors.fluidColorMap.put(fluid.getFluid(), fluid.getParticleColor().hashCode());
        }
    }

    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileEngineBiogas.class, new String[]{"Fuel", "Heating", "Burner"});
        Names.tankNamesMap.put(TileStill.class, new String[]{"In", "Out"});
        Names.tankNamesMap.put(TileFermenter.class, new String[]{"Resource Tank", "Product Tank"});
        Names.tankNamesMap.put(TileRaintank.class, new String[]{"Reservoir"});
    }

    private static void addFarmElement(IProbeInfo probeInfo, ItemStack[] farmIcons, String oneDirection) {
        AddonForestry.addFarmElement(probeInfo, farmIcons, oneDirection, false, new ItemStack[0]);
    }

    private static void addFarmElement(IProbeInfo probeInfo, ItemStack[] farmIcons, String oneDirection, boolean showInventory, ItemStack[] inventoryStacks) {
        probeInfo.element((IElement)new ElementForestryFarm(farmIcons, oneDirection, showInventory, inventoryStacks));
    }

    private static IProbeInfo addBeeHouseInventory(IProbeInfo probeInfo, boolean isApiary, ItemStack[] inventoryStacks) {
        return probeInfo.element((IElement)new ElementBeeHousingInventory(isApiary, inventoryStacks));
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (world != null && entity != null && entity instanceof IEntityButterfly) {
            IButterfly butterfly = ((IEntityButterfly)entity).getButterfly();
            if (!butterfly.isPureBred((IChromosomeType)EnumButterflyChromosome.SPECIES)) {
                probeInfo.text("Hybrid (" + butterfly.getGenome().getInactiveAllele((IChromosomeType)EnumButterflyChromosome.SPECIES).getName());
            }
            if (mode == ProbeMode.EXTENDED) {
                if (butterfly.isAnalyzed()) {
                    this.textPrefixed(probeInfo, "Size", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.SIZE).getName());
                    this.textPrefixed(probeInfo, "Production", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.SPEED).getName());
                    this.textPrefixed(probeInfo, "Lifespan", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.LIFESPAN).getName());
                    this.textPrefixed(probeInfo, "Fertility", butterfly.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.FERTILITY).getName());
                } else {
                    probeInfo.text("Unknown Genome");
                }
            }
        }
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (config != null && blockState != null && tile instanceof IBeeHousing && !(tile instanceof TileAlvearySieve) && !(tile instanceof TileAlvearySwarmer) || tile instanceof TileMoistener || tile instanceof TileFarm) {
            config.showChestContents(IProbeConfig.ConfigMode.NOT);
        } else {
            config.showChestContents(IProbeConfig.ConfigMode.EXTENDED);
        }
    }

    private ItemStack[] reorderBeeInvStacks(ItemStack[] old) {
        ItemStack[] ret = new ItemStack[old.length];
        ret[0] = old[0];
        ret[1] = old[1];
        ret[2] = old[7];
        ret[3] = old[6];
        ret[4] = old[8];
        ret[5] = old[2];
        ret[6] = old[5];
        ret[7] = old[3];
        ret[8] = old[4];
        if (old.length > 9) {
            ret[9] = old[9];
            ret[10] = old[10];
            ret[11] = old[11];
        }
        return ret;
    }
}

