/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.api.ITOPAddon;
import io.github.drmanganese.topaddons.api.ItemArmorProbed;
import io.github.drmanganese.topaddons.api.TOPAddon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class AddonManager {
    public static final List<ITOPAddon> ADDONS = new LinkedList<ITOPAddon>();
    public static final List<ItemArmorProbed> HELMETS = new ArrayList<ItemArmorProbed>();

    public static void preInit(FMLPreInitializationEvent event) {
        Set asmDataSet = event.getAsmData().getAll(TOPAddon.class.getName());
        TOPAddons.LOGGER.info("Found {} addon candidates.", new Object[]{asmDataSet.size()});
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            Map annotationInfo = asmData.getAnnotationInfo();
            String fancyName = (String)annotationInfo.get("fancyName");
            String dependency = (String)annotationInfo.get("dependency");
            int numHelmets = 0;
            boolean success = true;
            if (dependency == null || dependency.isEmpty()) {
                throw new IllegalArgumentException("No dependency specified for addon. Offender: " + asmData.getClassName());
            }
            if (Loader.isModLoaded((String)dependency)) {
                if (fancyName == null || fancyName.isEmpty()) {
                    for (ModContainer modContainer : Loader.instance().getModList()) {
                        if (!modContainer.getModId().equals(dependency)) continue;
                        fancyName = modContainer.getName();
                    }
                }
                try {
                    Class<?> clazz = Class.forName(asmData.getClassName());
                    if (ITOPAddon.class.isAssignableFrom(clazz)) {
                        ITOPAddon instance = (ITOPAddon)clazz.newInstance();
                        numHelmets = AddonManager.addHelmets(instance, fancyName);
                        ADDONS.add(instance);
                    }
                }
                catch (ClassNotFoundException e) {
                    TOPAddons.LOGGER.fatal("Classloader error while trying to create addon {}.", new Object[]{fancyName});
                    e.printStackTrace();
                    success = false;
                }
                catch (InstantiationException e) {
                    TOPAddons.LOGGER.error("Addon {} couldn't be instantiated, does its class have a constructor?", new Object[]{fancyName});
                    e.printStackTrace();
                    success = false;
                }
                catch (IllegalAccessException e) {
                    TOPAddons.LOGGER.error("Couldn't access constructor for addon {}.", new Object[]{fancyName});
                    e.printStackTrace();
                    success = false;
                }
                if (success) {
                    if (numHelmets > 0) {
                        TOPAddons.LOGGER.info("Created addon {} with {} helmets.", new Object[]{fancyName, numHelmets});
                        continue;
                    }
                    TOPAddons.LOGGER.info("Created addon {}.", new Object[]{fancyName});
                    continue;
                }
                TOPAddons.LOGGER.fatal("Failed to create addon {}", new Object[]{fancyName});
                continue;
            }
            TOPAddons.LOGGER.info("Dependency ({}) for addon {} not found, skipping...", new Object[]{dependency, fancyName});
        }
        Collections.sort(ADDONS, (o1, o2) -> o1.getClass().getName().compareToIgnoreCase(o2.getClass().getName()));
        Collections.sort(ADDONS, (o1, o2) -> {
            int order1 = o1.getClass().getAnnotation(TOPAddon.class).order();
            int order2 = o2.getClass().getAnnotation(TOPAddon.class).order();
            return Integer.compare(order1, order2);
        });
    }

    private static int addHelmets(ITOPAddon addon, String fancyName) {
        int ret = 0;
        if (addon.hasHelmets()) {
            for (Class<? extends ItemArmorProbed> clazz : addon.getHelmets()) {
                try {
                    ItemArmorProbed helmet = clazz.newInstance();
                    HELMETS.add(helmet);
                    ++ret;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    TOPAddons.LOGGER.error("An error occurred while trying to add HELMETS for addon {}", new Object[]{fancyName});
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }
}

