/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@TOPAddon(dependency="StorageDrawers")
public class AddonStorageDrawers
extends AddonBlank {
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (world.func_175625_s(data.getPos()) != null && world.func_175625_s(data.getPos()) instanceof TileEntityDrawers) {
            TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(data.getPos());
            if (tile.isShrouded()) {
                probeInfo.text(TextFormatting.GRAY + TextFormatting.ITALIC.toString() + "Shrouded");
                return;
            }
            if (mode == ProbeMode.EXTENDED) {
                for (int i = 0; i < tile.getDrawerCount(); ++i) {
                    ItemStack stack = tile.getDrawer(i).getStoredItemCopy();
                    if (stack == null) continue;
                    if (tile.isVending()) {
                        ItemStack infiStack = ItemStack.func_77944_b((ItemStack)stack);
                        infiStack.field_77994_a = 1;
                        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(infiStack).vertical(probeInfo.defaultLayoutStyle().spacing(0)).text(stack.func_82833_r()).text(TextFormatting.GRAY + "[\u221e]");
                        continue;
                    }
                    int r = stack.field_77994_a % 64;
                    int q = (stack.field_77994_a - r) / 64;
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(stack).vertical(probeInfo.defaultLayoutStyle().spacing(0)).text(stack.func_82833_r()).text(TextFormatting.GRAY + "[" + (stack.field_77994_a >= 64 ? q + "x64 + " : "") + r + "]");
                }
                this.textPrefixed(probeInfo, "Stack limit", tile.isUnlimited() ? "\u221e" : tile.getDrawerCapacity() + " (x" + tile.getEffectiveStorageMultiplier() + ")");
                if (tile.getOwner() != null && tile.getOwner().compareTo(player.func_110124_au()) != 0) {
                    probeInfo.text(TextFormatting.RED + TextFormatting.ITALIC.toString() + "Protected");
                }
            }
        }
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (world.func_175625_s(data.getPos()) instanceof TileEntityDrawers) {
            config.showChestContents(IProbeConfig.ConfigMode.NOT);
        }
    }
}

