/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.underphangables;

import fi.dy.masa.underphangables.UnderpHangables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AttackEntityEventHandler {
    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (player.field_71075_bZ.field_75098_d || target.func_180431_b(DamageSource.func_76365_a((EntityPlayer)player))) {
            return;
        }
        if (target instanceof EntityItemFrame) {
            EntityItemFrame entityItemFrame = (EntityItemFrame)target;
            ItemStack stack = entityItemFrame.func_82335_i();
            if (!target.field_70170_p.field_72995_K) {
                if (stack != null) {
                    if (target.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                        AttackEntityEventHandler.dropDisplayItemFromItemFrame(entityItemFrame, stack, AttackEntityEventHandler.getEntityYawFacing(target));
                    }
                    entityItemFrame.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
                    entityItemFrame.func_82334_a(null);
                } else {
                    if (target.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                        AttackEntityEventHandler.dropItemWithAdjustedPosition(new ItemStack(Items.field_151160_bD), (Entity)entityItemFrame, AttackEntityEventHandler.getEntityYawFacing(target));
                    }
                    entityItemFrame.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
                    entityItemFrame.func_70106_y();
                }
            }
            event.setCanceled(true);
        } else if (target instanceof EntityPainting) {
            if (!target.field_70170_p.field_72995_K) {
                if (target.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    AttackEntityEventHandler.dropItemWithAdjustedPosition(new ItemStack(Items.field_151159_an), target, AttackEntityEventHandler.getEntityYawFacing(target));
                }
                target.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
                target.func_70106_y();
            }
            event.setCanceled(true);
        }
    }

    public static EnumFacing getEntityYawFacing(Entity entity) {
        return EnumFacing.func_176733_a((double)entity.field_70177_z);
    }

    public static EntityItem createEntityItemWithoutHorizontalMotion(ItemStack stack, World world, double x, double y, double z, double motionY) {
        EntityItem entityItem = new EntityItem(world, x, y, z, stack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = motionY;
        entityItem.field_70179_y = 0.0;
        entityItem.func_174869_p();
        return entityItem;
    }

    public static void dropItemWithAdjustedPosition(ItemStack stack, Entity entity, EnumFacing facingToAdjustTo) {
        double posX = entity.field_70165_t + (double)((float)facingToAdjustTo.func_82601_c() * 0.15f);
        double posZ = entity.field_70161_v + (double)((float)facingToAdjustTo.func_82599_e() * 0.15f);
        EntityItem entityItem = AttackEntityEventHandler.createEntityItemWithoutHorizontalMotion(stack, entity.field_70170_p, posX, entity.field_70163_u, posZ, 0.1);
        if (entity.captureDrops) {
            entity.capturedDrops.add(entityItem);
        } else {
            entity.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    public static void dropDisplayItemFromItemFrame(EntityItemFrame entityItemFrame, ItemStack stack, EnumFacing facing) {
        float dropChance = 1.0f;
        try {
            dropChance = ((Float)ReflectionHelper.getPrivateValue(EntityItemFrame.class, (Object)entityItemFrame, (String[])new String[]{"field_82337_e", "itemDropChance"})).floatValue();
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            UnderpHangables.logger.warn("UnableToAccessFieldException while trying to get EntityItemFrame#itemDropChance");
        }
        if (stack != null && stack.field_77994_a > 0 && stack.func_77973_b() != null && entityItemFrame.field_70170_p.field_73012_v.nextFloat() < dropChance) {
            stack = stack.func_77946_l();
            try {
                Method method = ReflectionHelper.findMethod(EntityItemFrame.class, (Object)entityItemFrame, (String[])new String[]{"func_110131_b", "removeFrameFromMap"}, (Class[])new Class[]{ItemStack.class});
                method.invoke((Object)entityItemFrame, stack);
            }
            catch (ReflectionHelper.UnableToFindMethodException e) {
                UnderpHangables.logger.warn("UnableToFindMethodException while trying to do EntityItemFrame#removeFrameFromMap()");
            }
            catch (InvocationTargetException e) {
                UnderpHangables.logger.warn("InvocationTargetException while trying to do EntityItemFrame#removeFrameFromMap()");
            }
            catch (IllegalAccessException e) {
                UnderpHangables.logger.warn("IllegalAccessException while trying to do EntityItemFrame#removeFrameFromMap()");
            }
            AttackEntityEventHandler.dropItemWithAdjustedPosition(stack, (Entity)entityItemFrame, facing);
        }
    }
}

