/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.jefb.utils.tree;

import com.mrdimka.jefb.utils.tree.TreeMutation;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class TreeBreedingFigureout {
    public static List<TreeMutation> getAllTreeMutationsForSpecified(ITree out) {
        ArrayList<TreeMutation> mutations = new ArrayList<TreeMutation>();
        ITreeGenome genome = out.getGenome();
        List bms = TreeManager.treeRoot.getMutations(true);
        for (int i = 0; i < bms.size(); ++i) {
            ITreeMutation bm = (ITreeMutation)bms.get(i);
            ITree Tree = TreeManager.treeRoot.templateAsIndividual(bm.getTemplate());
            if (!out.getDisplayName().equals(Tree.getDisplayName())) continue;
            TreeMutation m = new TreeMutation();
            m.out = out;
            m.chance = bm.getBaseChance();
            m.in1 = TreeManager.treeRoot.templateAsIndividual(TreeManager.treeRoot.getTemplate(bm.getAllele0().getUID()));
            m.in2 = TreeManager.treeRoot.templateAsIndividual(TreeManager.treeRoot.getTemplate(bm.getAllele1().getUID()));
            mutations.add(m);
        }
        return mutations;
    }

    public static List<List<ItemStack>> inputsToItemListList(List<TreeMutation> muts) {
        ArrayList<List<ItemStack>> listList = new ArrayList<List<ItemStack>>();
        for (int m0 = 0; m0 < muts.size(); ++m0) {
            TreeMutation m = muts.get(m0);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(TreeManager.treeRoot.getMemberStack((IIndividual)m.in1, (ISpeciesType)EnumGermlingType.SAPLING));
            list.add(TreeManager.treeRoot.getMemberStack((IIndividual)m.in2, (ISpeciesType)EnumGermlingType.SAPLING));
            listList.add(list);
            list = new ArrayList();
            list.add(TreeManager.treeRoot.getMemberStack((IIndividual)m.in2, (ISpeciesType)EnumGermlingType.POLLEN));
            list.add(TreeManager.treeRoot.getMemberStack((IIndividual)m.in1, (ISpeciesType)EnumGermlingType.POLLEN));
            listList.add(list);
        }
        return listList;
    }

    public static ITree getFirstTreeToMutateInto(ITree out) {
        ITreeGenome genome = out.getGenome();
        List bms = TreeManager.treeRoot.getMutations(true);
        for (int i = 0; i < bms.size(); ++i) {
            ITreeMutation bm = (ITreeMutation)bms.get(i);
            ITree tree = TreeManager.treeRoot.templateAsIndividual(bm.getTemplate());
            if (!out.getDisplayName().equals(tree.getDisplayName())) continue;
            return TreeManager.treeRoot.templateAsIndividual(TreeManager.treeRoot.getTemplate(bm.getAllele0().getUID()));
        }
        return null;
    }

    public static ITree getSecondTreeToMutateInto(ITree out) {
        ITreeGenome genome = out.getGenome();
        List bms = TreeManager.treeRoot.getMutations(true);
        for (int i = 0; i < bms.size(); ++i) {
            ITreeMutation bm = (ITreeMutation)bms.get(i);
            ITree tree = TreeManager.treeRoot.templateAsIndividual(bm.getTemplate());
            if (!out.getDisplayName().equals(tree.getDisplayName())) continue;
            return TreeManager.treeRoot.templateAsIndividual(TreeManager.treeRoot.getTemplate(bm.getAllele1().getUID()));
        }
        return null;
    }

    public static float getChanceOfTreesToMutateInto(ITree out) {
        ITreeGenome genome = out.getGenome();
        List bms = TreeManager.treeRoot.getMutations(true);
        for (int i = 0; i < bms.size(); ++i) {
            ITreeMutation bm = (ITreeMutation)bms.get(i);
            ITree tree = TreeManager.treeRoot.templateAsIndividual(bm.getTemplate());
            if (!out.getDisplayName().equals(tree.getDisplayName())) continue;
            return bm.getBaseChance();
        }
        return 0.0f;
    }
}

