/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import ic2.api.event.TeBlockFinalCallEvent;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.ref.BlockName;
import ic2.core.ref.TeBlock;
import ic2.core.util.Tuple;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class TeBlockRegistry {
    private static final Map<String, ITeBlock> NAME_REGISTRY = new HashMap<String, ITeBlock>();
    private static final Map<Class<? extends TileEntityBlock>, ITeBlock> CLASS_REGISTRY = new IdentityHashMap<Class<? extends TileEntityBlock>, ITeBlock>();
    private static final Map<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>> RESOURCE_REGISTRY = new HashMap<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>>(5);
    private static boolean blocksBuilt;

    public static void add(ITeBlock teBlock) {
        if (!TeBlockRegistry.canBuildBlocks()) {
            throw new IllegalStateException("Cannot register additional ITeBlocks once block map built!");
        }
        assert (teBlock != null) : "Cannot register null ITeBlock!";
        NAME_REGISTRY.put(teBlock.getName(), teBlock);
        CLASS_REGISTRY.put(teBlock.getTeClass(), teBlock);
        ResourceLocation loc = teBlock.getIdentifier();
        if (!RESOURCE_REGISTRY.containsKey(loc)) {
            RESOURCE_REGISTRY.put(loc, new Tuple.T3(null, new HashSet(), new ArrayList()));
        }
        ((Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)loc).b).add(teBlock);
        if (teBlock.getId() > -1) {
            TeBlockRegistry.addID((List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)loc).c, teBlock);
        }
    }

    public static <E extends Enum<E>> void addAll(Class<E> enumClass, ResourceLocation identifier) {
        if (!TeBlockRegistry.canBuildBlocks()) {
            throw new IllegalStateException("Cannot register additional ITeBlocks once block map built!");
        }
        EnumSet<ITeBlock> blocks = EnumSet.allOf(enumClass);
        assert (!blocks.isEmpty()) : "Cannot register empty enum!";
        assert (identifier != null) : "Cannot register a null identifier!";
        if (!RESOURCE_REGISTRY.containsKey(identifier)) {
            RESOURCE_REGISTRY.put(identifier, new Tuple.T3(null, new HashSet<ITeBlock>(blocks), new ArrayList()));
        } else {
            ((Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).b).addAll(blocks);
        }
        List map = (List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).c;
        for (ITeBlock block : blocks) {
            NAME_REGISTRY.put(block.getName(), block);
            CLASS_REGISTRY.put(block.getTeClass(), block);
            if (block.getId() <= -1) continue;
            TeBlockRegistry.addID(map, block);
        }
    }

    private static void addID(List<ITeBlock> map, ITeBlock teBlock) {
        int ID = teBlock.getId();
        while (map.size() < ID) {
            map.add(null);
        }
        if (map.size() == ID) {
            map.add(teBlock);
        } else {
            if (map.get(ID) != null) {
                throw new IllegalArgumentException("The id " + ID + " for " + teBlock + " is already in use by " + map.get(ID) + '.');
            }
            map.set(ID, teBlock);
        }
    }

    public static void buildBlocks() {
        if (!TeBlockRegistry.canBuildBlocks()) {
            throw new IllegalStateException("Cannot build blocks twice!");
        }
        MinecraftForge.EVENT_BUS.post((Event)new TeBlockFinalCallEvent());
        blocksBuilt = true;
        ResourceLocation IC22 = TeBlock.invalid.getIdentifier();
        for (ResourceLocation location : RESOURCE_REGISTRY.keySet()) {
            BlockTileEntity block = IC22 == location ? new BlockTileEntity(BlockName.te) : new BlockTileEntity("te_" + location.func_110623_a(), location);
            TeBlockRegistry.RESOURCE_REGISTRY.get((Object)location).a = block;
        }
    }

    public static boolean canBuildBlocks() {
        return !blocksBuilt;
    }

    public static ITeBlock get(String name) {
        ITeBlock ret = NAME_REGISTRY.get(name);
        return ret != null ? ret : TeBlock.invalid;
    }

    public static ITeBlock get(ResourceLocation identifier, int ID) {
        return RESOURCE_REGISTRY.containsKey(identifier) ? (ITeBlock)((List)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).c).get(ID) : null;
    }

    public static ITeBlock get(Class<? extends TileEntityBlock> cls) {
        return CLASS_REGISTRY.get(cls);
    }

    public static BlockTileEntity get(ResourceLocation identifier) {
        return RESOURCE_REGISTRY.containsKey(identifier) ? (BlockTileEntity)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).a : null;
    }

    public static Iterable<Map.Entry<ResourceLocation, Set<ITeBlock>>> getAll() {
        return Collections2.transform(RESOURCE_REGISTRY.entrySet(), (Function)new Function<Map.Entry<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>>, Map.Entry<ResourceLocation, Set<ITeBlock>>>(){

            public AbstractMap.SimpleImmutableEntry<ResourceLocation, Set<ITeBlock>> apply(Map.Entry<ResourceLocation, Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>> input) {
                return new AbstractMap.SimpleImmutableEntry<ResourceLocation, Set<ITeBlock>>(input.getKey(), Collections.unmodifiableSet((Set)input.getValue().b));
            }
        });
    }

    public static Collection<BlockTileEntity> getAllBlocks() {
        return Collections2.transform(RESOURCE_REGISTRY.values(), (Function)new Function<Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>>, BlockTileEntity>(){

            public BlockTileEntity apply(Tuple.T3<BlockTileEntity, Set<ITeBlock>, List<ITeBlock>> input) {
                return (BlockTileEntity)input.a;
            }
        });
    }

    public static Set<ITeBlock> getAll(ResourceLocation identifier) {
        return RESOURCE_REGISTRY.containsKey(identifier) ? Collections.unmodifiableSet((Set)TeBlockRegistry.RESOURCE_REGISTRY.get((Object)identifier).b) : null;
    }

    private TeBlockRegistry() {
    }
}

