/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui;

import com.google.common.collect.ImmutableSet;
import ic2.api.recipe.IElectrolyzerRecipeManager;
import ic2.core.GuiIC2;
import ic2.core.block.machine.gui.GuiElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.gui.FluidSlot;
import ic2.core.gui.Gauge;
import ic2.core.gui.GuiElement;
import ic2.core.gui.IEnableHandler;
import ic2.core.init.Localization;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ElectrolyzerTankController {
    private int lastRecipeLength = 0;
    private final ElectrolyzerFluidSlot FAR_LEFT;
    private final ElectrolyzerFluidSlot LEFT;
    private final ElectrolyzerFluidSlot MIDDLE;
    private final ElectrolyzerFluidSlot RIGHT;
    private final ElectrolyzerFluidSlot FAR_RIGHT;
    private final TileEntityElectrolyzer electrolyzer;
    public static final Set<Integer> ONE_THREE_FIVE = ImmutableSet.of((Object)1, (Object)3, (Object)5);
    public static final Set<Integer> TWO_TO_FIVE = ImmutableSet.of((Object)2, (Object)3, (Object)4, (Object)5);
    public static final Set<Integer> FOUR_FIVE = ImmutableSet.of((Object)4, (Object)5);

    public ElectrolyzerTankController(GuiElectrolyzer gui, int x, int y, TileEntityElectrolyzer te) {
        this.electrolyzer = te;
        gui.addElement(FluidSlot.createFluidSlot(gui, x + 42, y, (IFluidTank)te.getInput()));
        ElectrolyzerProgressGauge.addSet(gui, x + 3, y + 20, te, this);
        this.FAR_LEFT = new ElectrolyzerFluidSlot(gui, x, y + 45);
        gui.addElement(this.FAR_LEFT);
        this.LEFT = new ElectrolyzerFluidSlot(gui, x + 21, y + 45);
        gui.addElement(this.LEFT);
        this.MIDDLE = new ElectrolyzerFluidSlot(gui, x + 42, y + 45);
        gui.addElement(this.MIDDLE);
        this.RIGHT = new ElectrolyzerFluidSlot(gui, x + 63, y + 45);
        gui.addElement(this.RIGHT);
        this.FAR_RIGHT = new ElectrolyzerFluidSlot(gui, x + 84, y + 45);
        gui.addElement(this.FAR_RIGHT);
    }

    public int getLastRecipeLength() {
        return this.lastRecipeLength;
    }

    public void tick() {
        this.FAR_LEFT.fluid = (this.LEFT.fluid = (this.MIDDLE.fluid = (this.RIGHT.fluid = (this.FAR_RIGHT.fluid = null))));
        if (this.electrolyzer.getCurrentRecipe() == null) {
            this.lastRecipeLength = 0;
            return;
        }
        IElectrolyzerRecipeManager.ElectrolyzerOutput[] outputs = this.electrolyzer.getCurrentRecipe().outputs;
        this.lastRecipeLength = outputs.length;
        int intLength = this.lastRecipeLength;
        if (intLength < 1) {
            return;
        }
        Integer length = intLength;
        if (ONE_THREE_FIVE.contains(length)) {
            this.MIDDLE.fluid = outputs[intLength / 2].getFullOutput();
        }
        if (TWO_TO_FIVE.contains(length)) {
            this.LEFT.fluid = outputs[intLength < 4 ? 0 : 1].getFullOutput();
            this.RIGHT.fluid = outputs[intLength - (intLength < 4 ? 1 : 2)].getFullOutput();
        }
        if (FOUR_FIVE.contains(length)) {
            this.FAR_LEFT.fluid = outputs[0].getFullOutput();
            this.FAR_RIGHT.fluid = outputs[intLength - 1].getFullOutput();
        }
    }

    public static class ElectrolyzerFluidSlot
    extends GuiElement<ElectrolyzerFluidSlot> {
        private static final int posU = 8;
        private static final int posV = 160;
        private static final int normalWidth = 18;
        private static final int normalHeight = 18;
        private static final int fluidOffsetX = 1;
        private static final int fluidOffsetY = 1;
        private static final int fluidNetWidth = 16;
        private static final int fluidNetHeight = 16;
        private Pair<FluidStack, EnumFacing> fluid;

        public ElectrolyzerFluidSlot(GuiIC2<?> gui, int x, int y) {
            super(gui, x, y, 18, 18);
        }

        @Override
        public void drawBackground(int mouseX, int mouseY) {
            FluidStack fluid;
            ElectrolyzerFluidSlot.bindCommonTexture();
            this.gui.drawTexturedRect(this.x, this.y, this.width, this.height, 8.0, 160.0);
            if (this.fluid != null && (fluid = (FluidStack)this.fluid.getLeft()) != null && fluid.amount > 0) {
                int fluidX = this.x + 1;
                int fluidY = this.y + 1;
                Fluid liquid = fluid.getFluid();
                TextureAtlasSprite sprite = liquid != null ? ElectrolyzerFluidSlot.getBlockTextureMap().func_110572_b(liquid.getStill(fluid).toString()) : null;
                int color = liquid != null ? liquid.getColor(fluid) : -1;
                ElectrolyzerFluidSlot.bindBlockTexture();
                this.gui.drawSprite(fluidX, fluidY, 16.0, 16.0, sprite, color, 1.0);
            }
        }

        @Override
        protected List<String> getToolTip() {
            FluidStack fluid;
            ArrayList<String> ret = new ArrayList<String>(3);
            if (this.fluid != null && (fluid = (FluidStack)this.fluid.getLeft()) != null) {
                Fluid liquid = fluid.getFluid();
                if (liquid != null) {
                    ret.add(liquid.getLocalizedName(fluid));
                    ret.add("Amount: " + fluid.amount + " " + Localization.translate("ic2.generic.text.mb"));
                    ret.add("Output Tank: " + StringUtils.capitalize((String)((EnumFacing)this.fluid.getRight()).func_176610_l()));
                } else {
                    ret.add("Invalid FluidStack instance.");
                }
            }
            return ret;
        }
    }

    public static class ElectrolyzerProgressGauge
    extends Gauge<ElectrolyzerProgressGauge> {
        private final TileEntityElectrolyzer electrolyzer;

        public static void addSet(GuiElectrolyzer gui, int x, int y, TileEntityElectrolyzer te, ElectrolyzerTankController controller) {
            gui.addElement((GuiElement<?>)new ElectrolyzerProgressGauge(gui, x + 45, y, te, ElectrolyzerGauges.ONE_TANK).withEnableHandler(ElectrolyzerProgressGauge.getEnableHandler(controller, 1)));
            gui.addElement((GuiElement<?>)new ElectrolyzerProgressGauge(gui, x + 21, y, te, ElectrolyzerGauges.TWO_TANK).withEnableHandler(ElectrolyzerProgressGauge.getEnableHandler(controller, 2)));
            gui.addElement((GuiElement<?>)new ElectrolyzerProgressGauge(gui, x + 21, y, te, ElectrolyzerGauges.THREE_TANK).withEnableHandler(ElectrolyzerProgressGauge.getEnableHandler(controller, 3)));
            gui.addElement((GuiElement<?>)new ElectrolyzerProgressGauge(gui, x, y, te, ElectrolyzerGauges.FOUR_TANK).withEnableHandler(ElectrolyzerProgressGauge.getEnableHandler(controller, 4)));
            gui.addElement((GuiElement<?>)new ElectrolyzerProgressGauge(gui, x, y, te, ElectrolyzerGauges.FIVE_TANK).withEnableHandler(ElectrolyzerProgressGauge.getEnableHandler(controller, 5)));
        }

        private static IEnableHandler getEnableHandler(final ElectrolyzerTankController controller, final int tank) {
            return new IEnableHandler(){

                @Override
                public boolean isEnabled() {
                    return controller.getLastRecipeLength() == tank;
                }
            };
        }

        private ElectrolyzerProgressGauge(GuiIC2<?> gui, int x, int y, TileEntityElectrolyzer te, ElectrolyzerGauges style) {
            super(gui, x, y, style.properties);
            this.electrolyzer = te;
        }

        @Override
        protected double getRatio() {
            return this.electrolyzer.getProgress();
        }

        public static enum ElectrolyzerGauges {
            ONE_TANK(new Gauge.GaugePropertyBuilder(57, 232, 12, 23, Gauge.GaugePropertyBuilder.GaugeOrientation.Down).build()),
            TWO_TANK(new Gauge.GaugePropertyBuilder(1, 232, 54, 23, Gauge.GaugePropertyBuilder.GaugeOrientation.Down).build()),
            THREE_TANK(new Gauge.GaugePropertyBuilder(41, 159, 54, 23, Gauge.GaugePropertyBuilder.GaugeOrientation.Down).build()),
            FOUR_TANK(new Gauge.GaugePropertyBuilder(1, 208, 96, 23, Gauge.GaugePropertyBuilder.GaugeOrientation.Down).build()),
            FIVE_TANK(new Gauge.GaugePropertyBuilder(1, 184, 96, 23, Gauge.GaugePropertyBuilder.GaugeOrientation.Down).build());

            public final Gauge.GaugeProperties properties;

            private ElectrolyzerGauges(Gauge.GaugeProperties properties) {
                this.properties = properties;
            }
        }
    }
}

