/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.jetpack;

import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.armor.jetpack.IJetpack;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class JetpackLogic {
    private static boolean lastJetpackUsed;
    private static AudioSource audioSource;

    public static boolean useJetpack(EntityPlayer player, boolean hoverMode, IJetpack ijetpack) {
        int worldHeight;
        int maxFlightHeight;
        double y;
        ItemStack jetpack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (ijetpack.getChargeLevel(jetpack) <= 0.0) {
            return false;
        }
        float power = ijetpack.getPower(jetpack);
        float dropPercentage = ijetpack.getDropPercentage(jetpack);
        if (ijetpack.getChargeLevel(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (ijetpack.getChargeLevel(jetpack) * (double)dropPercentage));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 1.0f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        if ((y = player.field_70163_u) > (double)((maxFlightHeight = (int)((float)(worldHeight = IC2.getWorldHeight(player.field_70170_p)) / ijetpack.getWorldHeightDivisor(jetpack))) - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = ijetpack.getHoverMultiplier(jetpack, true);
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -ijetpack.getHoverMultiplier(jetpack, false);
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        if (!player.field_70122_E) {
            ijetpack.drainEnergy(jetpack, consume);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public static void onArmorTick(World world, EntityPlayer player, ItemStack stack, IJetpack jetpack) {
        if (player.func_184582_a(EntityEquipmentSlot.CHEST) != stack) {
            return;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                } else {
                    IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                }
            }
        }
        if (IC2.keyboard.isJumpKeyDown(player) || hoverMode) {
            jetpackUsed = JetpackLogic.useJetpack(player, hoverMode, jetpack);
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource(player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }
}

