/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.IHitSoundOverride;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemDrill
extends ItemElectricTool
implements IHitSoundOverride {
    protected ItemDrill(ItemName name, int operationEnergyCost, ItemElectricTool.HarvestLevel harvestLevel) {
        super(name, operationEnergyCost, harvestLevel, EnumSet.of(ItemElectricTool.ToolClass.Pickaxe, ItemElectricTool.ToolClass.Shovel));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHitSoundForBlock(EntityPlayerSP player, World world, BlockPos pos, ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (hardness > 1.0f || hardness < 0.0f) {
            return "Tools/Drill/DrillHard.ogg";
        }
        return "Tools/Drill/DrillSoft.ogg";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getBreakSoundForBlock(EntityPlayerSP player, World world, BlockPos pos, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if ((double)hardness > 0.5 || !ElectricItem.manager.canUse(stack, 80.0)) {
            return null;
        }
        return "Tools/Drill/DrillSoft.ogg";
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        float speed = super.func_150893_a(stack, state);
        EntityPlayer player = ItemDrill.getPlayerHoldingItem(stack);
        if (player != null) {
            if (player.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)player)) {
                speed *= 5.0f;
            }
            if (!player.field_70122_E) {
                speed *= 5.0f;
            }
        }
        return speed;
    }

    private static EntityPlayer getPlayerHoldingItem(ItemStack stack) {
        if (IC2.platform.isRendering()) {
            return ItemDrill.getClientPlayerHoldingItem(stack);
        }
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (player.field_71071_by.func_70448_g() != stack) continue;
            return player;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getClientPlayerHoldingItem(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71071_by.func_70448_g() == stack) {
            return player;
        }
        return null;
    }
}

