/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.ref.BlockName;
import java.lang.reflect.Constructor;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBlockDust;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ParticleUtil {
    private static final Constructor<ParticleBlockDust> particleBlockDust_ctor = ParticleUtil.getParticleBlockDustCtor();
    private static final Constructor<ParticleDigging> particleDigging_ctor = ParticleUtil.getParticleDiggingCtor();

    public static void spawnBlockLandParticles(World world, double x, double y, double z, int count, ITeBlock teBlock) {
        Minecraft mc = Minecraft.func_71410_x();
        Random rnd = world.field_73012_v;
        if (mc.field_71441_e != world || mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71474_y.field_74362_aa > 1 || mc.field_71474_y.field_74362_aa == 1 && rnd.nextInt(3) == 0) {
            return;
        }
        if (mc.field_71439_g.func_70092_e(x, y, z) > 1024.0) {
            return;
        }
        double speed = 0.15;
        for (int i = 0; i < count; ++i) {
            ParticleDigging particle;
            double mx = rnd.nextGaussian() * 0.15;
            double my = rnd.nextGaussian() * 0.15;
            double mz = rnd.nextGaussian() * 0.15;
            try {
                particle = (ParticleDigging)particleBlockDust_ctor.newInstance(world, x, y, z, mx, my, mz, BlockName.te.getBlockState(teBlock));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            particle.func_174845_l();
            mc.field_71452_i.func_78873_a((Particle)particle);
        }
    }

    public static void spawnBlockHitParticles(TileEntityBlock te, EnumFacing side) {
        ParticleDigging particle;
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        double offset = 0.1;
        AxisAlignedBB aabb = te.getVisualBoundingBox();
        double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - offset * 2.0) + offset + aabb.field_72340_a;
        double y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - offset * 2.0) + offset + aabb.field_72338_b;
        double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - offset * 2.0) + offset + aabb.field_72339_c;
        switch (side) {
            case DOWN: {
                y = (double)pos.func_177956_o() + aabb.field_72338_b - offset;
                break;
            }
            case UP: {
                y = (double)pos.func_177956_o() + aabb.field_72337_e + offset;
                break;
            }
            case NORTH: {
                z = (double)pos.func_177952_p() + aabb.field_72339_c - offset;
                break;
            }
            case SOUTH: {
                z = (double)pos.func_177952_p() + aabb.field_72334_f + offset;
                break;
            }
            case WEST: {
                x = (double)pos.func_177958_n() + aabb.field_72340_a - offset;
                break;
            }
            case EAST: {
                x = (double)pos.func_177958_n() + aabb.field_72336_d + offset;
                break;
            }
            default: {
                throw new IllegalStateException("invalid facing: " + side);
            }
        }
        try {
            particle = particleDigging_ctor.newInstance(world, x, y, z, 0, 0, 0, te.getBlockState());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        particle.func_174846_a(pos);
        particle.func_70543_e(0.2f);
        particle.func_70541_f(0.6f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    private static Constructor<ParticleBlockDust> getParticleBlockDustCtor() {
        try {
            Constructor<ParticleBlockDust> ret = ParticleBlockDust.class.getDeclaredConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, IBlockState.class);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor<ParticleDigging> getParticleDiggingCtor() {
        try {
            Constructor<ParticleDigging> ret = ParticleDigging.class.getDeclaredConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, IBlockState.class);
            ret.setAccessible(true);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

