/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.capability.mana;

import elucent.roots.capability.mana.DefaultManaCapability;
import elucent.roots.capability.mana.IManaCapability;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class ManaProvider
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    private IManaCapability cMana = null;
    @CapabilityInject(value=IManaCapability.class)
    public static final Capability<IManaCapability> manaCapability = null;

    public ManaProvider() {
        this.cMana = new DefaultManaCapability();
    }

    public ManaProvider(IManaCapability p) {
        this.cMana = p;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == manaCapability;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (manaCapability != null && capability == manaCapability) {
            return (T)this.cMana;
        }
        return null;
    }

    public static IManaCapability get(EntityPlayer player) {
        return player != null && player.hasCapability(manaCapability, null) ? (IManaCapability)player.getCapability(manaCapability, null) : null;
    }

    public NBTTagCompound serializeNBT() {
        return this.cMana.saveNBTData();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.cMana.loadNBTData(nbt);
    }
}

