/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.component;

import elucent.roots.component.EnumCastType;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ComponentBase {
    String name = "";
    String effectName = "";
    ItemStack itemSource = null;
    public Vec3d primaryColor = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d secondaryColor = new Vec3d(0.0, 0.0, 0.0);
    public int xpCost = 0;
    public boolean singleCast = true;
    Random random = new Random();
    TextFormatting textColor = TextFormatting.WHITE;

    public ComponentBase setPrimaryColor(double r, double g, double b) {
        this.primaryColor = new Vec3d(r, g, b);
        return this;
    }

    public ComponentBase setSecondaryColor(double r, double g, double b) {
        this.secondaryColor = new Vec3d(r, g, b);
        return this;
    }

    public ComponentBase setTextColor(TextFormatting color) {
        this.textColor = color;
        return this;
    }

    public ComponentBase(String name, String effectName, ItemStack item, int cost) {
        this.name = name;
        this.xpCost = cost;
        this.effectName = effectName;
        this.itemSource = item;
    }

    public ComponentBase(String name, String effectName, Item item, int cost) {
        this.name = name;
        this.xpCost = cost;
        this.effectName = effectName;
        this.itemSource = new ItemStack(item);
    }

    public ComponentBase(String name, String effectName, Block item, int cost) {
        this.name = name;
        this.xpCost = cost;
        this.effectName = effectName;
        this.itemSource = new ItemStack(item);
    }

    public ComponentBase(String name, String effectName, Item item, int meta, int cost) {
        this.name = name;
        this.xpCost = cost;
        this.effectName = effectName;
        this.itemSource = new ItemStack(item, 1, meta);
    }

    public ComponentBase(String name, String effectName, Block item, int meta, int cost) {
        this.name = name;
        this.xpCost = cost;
        this.effectName = effectName;
        this.itemSource = new ItemStack(item, 1, meta);
    }

    public String getName() {
        return this.name;
    }

    public String getEffectName() {
        return I18n.func_135052_a((String)("roots.component." + this.name + ".name"), (Object[])new Object[0]);
    }

    public TextFormatting getTextColor() {
        return this.textColor;
    }

    public ItemStack getItem() {
        return this.itemSource;
    }

    public void doEffect(World world, Entity caster, EnumCastType type, double x, double y, double z, double potency, double duration, double size) {
    }

    public void doEffect(World world, UUID casterId, Vec3d direction, EnumCastType type, double x, double y, double z, double potency, double duration, double size) {
    }

    public void castingAction(EntityLivingBase player, int count, double potency, double efficiency, double size) {
    }
}

