/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.component.components;

import elucent.roots.PlayerManager;
import elucent.roots.RegistryManager;
import elucent.roots.Util;
import elucent.roots.component.ComponentBase;
import elucent.roots.component.EnumCastType;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ComponentLilac
extends ComponentBase {
    Random random = new Random();

    public ComponentLilac() {
        super("lilac", "Growth", (Block)Blocks.field_150398_cm, 1, 14);
    }

    public boolean growBlockSafe(World world, BlockPos pos, int potency) {
        if (world.func_180495_p(pos).func_177230_c() instanceof IGrowable && this.random.nextInt(5 - potency) < 2) {
            ((IGrowable)world.func_180495_p(pos).func_177230_c()).func_176474_b(world, this.random, pos, world.func_180495_p(pos));
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150388_bm && this.random.nextInt(5 - potency) < 2) {
            BlockNetherWart wart = (BlockNetherWart)world.func_180495_p(pos).func_177230_c();
            IBlockState state = world.func_180495_p(pos);
            int age = (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
            if (age < 3) {
                state = state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1));
                world.func_180501_a(pos, state, 2);
                return true;
            }
        }
        return false;
    }

    @Override
    public void doEffect(World world, Entity caster, EnumCastType type, double x, double y, double z, double potency, double duration, double size) {
        if (type == EnumCastType.SPELL && caster instanceof EntityPlayer && !world.field_72995_K) {
            boolean fullEfficiency;
            BlockPos pos = Util.getRayTrace(world, (EntityPlayer)caster, 6 + 2 * (int)size);
            boolean bl = fullEfficiency = this.growBlockSafe(world, pos, (int)potency) && this.growBlockSafe(world, pos.func_177974_f(), (int)potency) && this.growBlockSafe(world, pos.func_177976_e(), (int)potency) && this.growBlockSafe(world, pos.func_177978_c(), (int)potency) && this.growBlockSafe(world, pos.func_177968_d(), (int)potency);
            if (fullEfficiency && caster instanceof EntityPlayer && !((EntityPlayer)caster).func_189102_a(RegistryManager.achieveSpellGrowth)) {
                PlayerManager.addAchievement((EntityPlayer)caster, RegistryManager.achieveSpellGrowth);
            }
        }
    }

    @Override
    public void doEffect(World world, UUID casterId, Vec3d direction, EnumCastType type, double x, double y, double z, double potency, double duration, double size) {
        if (type == EnumCastType.SPELL && !world.field_72995_K) {
            EntityPlayer player;
            boolean fullEfficiency;
            BlockPos pos = new BlockPos(x, y, z);
            boolean bl = fullEfficiency = this.growBlockSafe(world, pos, (int)potency) && this.growBlockSafe(world, pos.func_177974_f(), (int)potency) && this.growBlockSafe(world, pos.func_177976_e(), (int)potency) && this.growBlockSafe(world, pos.func_177978_c(), (int)potency) && this.growBlockSafe(world, pos.func_177968_d(), (int)potency);
            if (fullEfficiency && (player = world.func_152378_a(casterId)) != null && !player.func_189102_a(RegistryManager.achieveSpellGrowth)) {
                PlayerManager.addAchievement(player, RegistryManager.achieveSpellGrowth);
            }
        }
    }
}

