/*
 * Decompiled with CFR 0.152.
 */
package elucent.roots.ritual;

import elucent.roots.RegistryManager;
import elucent.roots.Util;
import elucent.roots.tileentity.TileEntityAltar;
import elucent.roots.tileentity.TileEntityBrazier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RitualBase {
    public ArrayList<Block> blocks = new ArrayList();
    public ArrayList<BlockPos> positions = new ArrayList();
    public ArrayList<ItemStack> incenses = new ArrayList();
    public ArrayList<ItemStack> ingredients = new ArrayList();
    public Vec3d color = new Vec3d(255.0, 255.0, 255.0);
    public Vec3d secondaryColor = new Vec3d(255.0, 255.0, 255.0);
    public String name = "";

    public RitualBase(String parName, double r, double g, double b) {
        this.name = parName;
        this.color = new Vec3d(r, g, b);
        this.secondaryColor = new Vec3d(r, g, b);
    }

    public RitualBase(String parName, double r, double g, double b, double r2, double g2, double b2) {
        this.name = parName;
        this.color = new Vec3d(r, g, b);
        this.secondaryColor = new Vec3d(r2, g2, b2);
    }

    public RitualBase addBlock(Block b, int x, int y, int z) {
        this.blocks.add(b);
        this.positions.add(new BlockPos(x, y, z));
        return this;
    }

    public RitualBase addIngredient(ItemStack i) {
        this.ingredients.add(i);
        return this;
    }

    public RitualBase addIncense(ItemStack i) {
        this.incenses.add(i);
        return this;
    }

    public void doEffect(World world, BlockPos pos, List<ItemStack> inventory, List<ItemStack> incenses) {
    }

    public boolean matches(World world, BlockPos pos) {
        if (this.positions.size() > 0) {
            for (int i = 0; i < this.positions.size(); ++i) {
                if (world.func_180495_p(pos.func_177982_a(this.positions.get(i).func_177958_n(), this.positions.get(i).func_177956_o(), this.positions.get(i).func_177952_p())).func_177230_c() == this.blocks.get(i)) continue;
                return false;
            }
        }
        ArrayList<ItemStack> test = new ArrayList<ItemStack>();
        for (int i = -7; i < 8; ++i) {
            for (int j = -7; j < 8; ++j) {
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != RegistryManager.brazier || world.func_175625_s(pos.func_177982_a(i, 0, j)) == null) continue;
                TileEntityBrazier teb = (TileEntityBrazier)world.func_175625_s(pos.func_177982_a(i, 0, j));
                if (!teb.burning) continue;
                test.add(teb.heldItem);
            }
        }
        return Util.itemListsMatch(this.incenses, test) && Util.itemListsMatchWithSize(this.ingredients, ((TileEntityAltar)world.func_175625_s((BlockPos)pos)).inventory);
    }
}

