/*
 * Decompiled with CFR 0.152.
 */
package gr.watchful.whosebed;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MyEventListener {
    private HashMap<UUID, BlockPos> players;
    private HashMap<BlockPos, HashSet<UUID>> spawns;
    private Boolean playersLoaded = false;

    public MyEventListener() {
        this.init();
    }

    private void init() {
        this.players = new HashMap();
        this.spawns = new HashMap();
    }

    @SubscribeEvent
    public void onWorldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (this.playersLoaded.booleanValue()) {
            return;
        }
        this.init();
        File playerDataFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "playerdata");
        if (playerDataFolder == null || !playerDataFolder.exists() || !playerDataFolder.isDirectory()) {
            System.out.println("Can't find playerdata folder: " + playerDataFolder.getAbsolutePath());
            return;
        }
        for (File file : playerDataFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dat");
            }
        })) {
            try {
                NBTTagCompound playerTag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                if (!playerTag.func_74764_b("SpawnX") || !playerTag.func_74764_b("SpawnY") || !playerTag.func_74764_b("SpawnZ")) continue;
                BlockPos spawnPoint = new BlockPos(playerTag.func_74762_e("SpawnX"), playerTag.func_74762_e("SpawnY"), playerTag.func_74762_e("SpawnZ"));
                UUID uuid = UUID.fromString(file.getName().substring(0, file.getName().length() - 4));
                this.addSpawn(uuid, spawnPoint);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.playersLoaded = true;
    }

    @SubscribeEvent
    public void onWorldUnloadEvent(WorldEvent.Unload event) {
        System.out.println("Unloading");
        if (event.getWorld().field_72995_K) {
            this.playersLoaded = false;
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        if (event.getEntityPlayer().func_70613_aW() && event.shouldSetSpawn()) {
            BlockPos spawnPoint = new BlockPos(event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v);
            this.updatePlayerSpawn(event.getEntityPlayer(), spawnPoint);
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getEntityPlayer().func_70093_af() && event.getWorld().func_180495_p(event.getPos()).func_177230_c().equals(Blocks.field_150324_C)) {
            BlockPos pos = event.getPos();
            Block block = event.getWorld().func_180495_p(pos).func_177230_c();
            if (block.isBedFoot((IBlockAccess)event.getWorld(), pos)) {
                pos = pos.func_177972_a(block.getBedDirection(event.getWorld().func_180495_p(pos), (IBlockAccess)event.getWorld(), pos));
            }
            System.out.println(event.getEntityPlayer().func_70005_c_() + " clicked a bed at " + pos);
            HashSet<String> players = this.getPlayersAtSpawn(pos, event.getWorld());
            StringBuilder bldr = new StringBuilder();
            if (players == null || players.size() == 0) {
                bldr.append("No one sleeps here");
            } else {
                bldr.append("This is the bed of ");
                int i = 0;
                for (String player : players) {
                    if (players.size() != 1 && i != 0) {
                        if (players.size() - 1 == i) {
                            bldr.append(" and ");
                        } else {
                            bldr.append(", ");
                        }
                    }
                    bldr.append(player);
                    ++i;
                }
            }
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(bldr.toString()));
            event.setCanceled(true);
        }
    }

    private HashSet<String> getPlayersAtSpawn(BlockPos location, World world) {
        if (!this.spawns.containsKey(location)) {
            return null;
        }
        HashSet<String> playerNames = new HashSet<String>();
        for (UUID player : this.spawns.get(location)) {
            playerNames.add(world.func_73046_m().func_152358_ax().func_152652_a(player).getName());
        }
        return playerNames;
    }

    private void updatePlayerSpawn(EntityPlayer player, BlockPos spawnPoint) {
        UUID uuid = player.func_110124_au();
        BlockPos oldSpawnPoint = this.players.get(uuid);
        if (oldSpawnPoint != null) {
            if (oldSpawnPoint.equals((Object)spawnPoint)) {
                return;
            }
            if (this.spawns.containsKey(oldSpawnPoint)) {
                if (this.spawns.get(oldSpawnPoint).size() > 1) {
                    this.spawns.get(oldSpawnPoint).remove(uuid);
                } else {
                    this.spawns.remove(oldSpawnPoint);
                }
            }
        }
        this.addSpawn(uuid, spawnPoint);
    }

    private void addSpawn(UUID uuid, BlockPos spawnPoint) {
        System.out.println(uuid + " : " + spawnPoint);
        this.players.put(uuid, spawnPoint);
        if (!this.spawns.containsKey(spawnPoint)) {
            this.spawns.put(spawnPoint, new HashSet());
        }
        this.spawns.get(spawnPoint).add(uuid);
    }
}

