/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests;

import org.apache.logging.log4j.Level;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for ColossalChests.\nDO NOT EDIT MANUALLY!")
    public static String version = "1.3.10";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If items should be ejected from the chests if one of the structure blocks are removed.")
    public static boolean ejectItemsOnDestroy = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If the higher tier metal variants can be crafted.")
    public static boolean metalVariants = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Maximum number of slots per packet for inventory slots fragmentation.")
    public static int maxSlotsPerPacket = 2500;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super((ModBase)ColossalChests._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        if (!version.equals("1.3.10")) {
            this.getMod().log(Level.WARN, "The config file of ColossalChests is out of date and might cause problems, please remove it so it can be regenerated.");
        }
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-5");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)ColossalChests._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.9/ColossalChests.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

