/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.BlockPropertyManagerComponent;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;

public class ChestWall
extends ConfigurableBlock
implements CubeDetector.IDetectionListener {
    @BlockProperty
    public static final PropertyBool ACTIVE = ColossalChest.ACTIVE;
    @BlockProperty
    public static final PropertyMaterial MATERIAL = ColossalChest.MATERIAL;
    private static ChestWall _instance = null;

    public static ChestWall getInstance() {
        return _instance;
    }

    public ChestWall(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return ColossalChest.isToolEffectiveShared(type, state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState blockState, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.captureBlockSnapshots) {
            ColossalChest.triggerDetector(world, pos, true);
        }
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState blockState) {
        super.func_176213_c(world, blockPos, blockState);
        if (!world.captureBlockSnapshots && blockState.func_177230_c() == this && !((Boolean)blockState.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            ColossalChest.triggerDetector(world, blockPos, true);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            ColossalChest.triggerDetector(world, pos, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public void onDetect(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            boolean change = (Boolean)world.func_180495_p(location).func_177229_b((IProperty)ACTIVE) == false;
            world.func_180501_a(location, world.func_180495_p(location).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                TileColossalChest.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float posX, float posY, float posZ) {
        if (((Boolean)blockState.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(world, blockPos);
            if (tileLocation != null) {
                world.func_180495_p(tileLocation).func_177230_c().func_180639_a(world, tileLocation, world.func_180495_p(tileLocation), player, hand, heldItem, side, posX, posY, posZ);
                return true;
            }
        } else {
            ColossalChest.addPlayerChatError(world, blockPos, player, hand);
        }
        return super.func_180639_a(world, blockPos, blockState, player, hand, heldItem, side, posX, posY, posZ);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (PropertyMaterial.Type material : PropertyMaterial.Type.values()) {
            list.add(new ItemStack((Block)ChestWall.getInstance(), 1, material.ordinal()));
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.propertyManager = new BlockPropertyManagerComponent((Block)this, (Comparator)new BlockPropertyManagerComponent.PropertyComparator(){

            public int compare(IProperty o1, IProperty o2) {
                return o2.func_177701_a().compareTo(o1.func_177701_a());
            }
        }, (Comparator)new BlockPropertyManagerComponent.UnlistedPropertyComparator());
        return this.propertyManager.createDelegatedBlockState();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta * 2, placer);
    }

    public int func_180651_a(IBlockState state) {
        return ((PropertyMaterial.Type)((Object)state.func_177229_b((IProperty)ColossalChest.MATERIAL))).ordinal();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && ColossalChest.canPlace(worldIn, pos);
    }
}

