/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.client.gui.container.GuiColossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.BlockPropertyManagerComponent;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainerGui;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;

public class ColossalChest
extends ConfigurableBlockContainerGui
implements CubeDetector.IDetectionListener {
    @BlockProperty
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    @BlockProperty
    public static final PropertyMaterial MATERIAL = PropertyMaterial.create("material", PropertyMaterial.Type.class);
    private static ColossalChest _instance = null;

    public static ColossalChest getInstance() {
        return _instance;
    }

    public ColossalChest(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e, TileColossalChest.class);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.setRotatable(false);
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public static boolean isToolEffectiveShared(String type, IBlockState state) {
        if (PropertyMaterial.Type.WOOD == state.func_177229_b((IProperty)MATERIAL)) {
            return "axe".equals(type);
        }
        return "pickaxe".equals(type);
    }

    public static boolean canPlace(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IBlockState blockState = world.func_180495_p(pos.func_177972_a(side));
            if (!blockState.func_177228_b().containsKey((Object)ACTIVE) || !((Boolean)blockState.func_177229_b((IProperty)ACTIVE)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return ColossalChest.isToolEffectiveShared(type, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public static DetectionResult triggerDetector(World world, BlockPos blockPos, boolean valid) {
        return TileColossalChest.detector.detect(world, blockPos, valid ? null : blockPos, (CubeDetector.IValidationAction)new MaterialValidationAction(), true);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileColossalChest tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_82837_s() && (tile = (TileColossalChest)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileColossalChest.class))) != null) {
            tile.setCustomName(stack.func_82833_r());
            tile.setSize(Vec3i.field_177959_e);
        }
        ColossalChest.triggerDetector(world, pos, true);
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState blockState) {
        super.func_176213_c(world, blockPos, blockState);
        ColossalChest.triggerDetector(world, blockPos, true);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            ColossalChest.triggerDetector(world, pos, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public void onDetect(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            world.func_180501_a(location, world.func_180495_p(location).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            TileColossalChest tile = (TileColossalChest)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)location, TileColossalChest.class));
            if (tile != null) {
                tile.setMaterial((PropertyMaterial.Type)((Object)BlockHelpers.getSafeBlockStateProperty((IBlockState)world.func_180495_p(location), (IProperty)MATERIAL, (Object)((Object)PropertyMaterial.Type.WOOD))));
                tile.setSize(valid ? size : Vec3i.field_177959_e);
                tile.setCenter(new Vec3d((double)originCorner.func_177958_n() + (double)size.func_177958_n() / 2.0, (double)originCorner.func_177956_o() + (double)size.func_177956_o() / 2.0, (double)originCorner.func_177952_p() + (double)size.func_177952_p() / 2.0));
            }
        }
    }

    public Class<? extends Container> getContainer() {
        return ContainerColossalChest.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiColossalChest.class;
    }

    @Nullable
    public static BlockPos getCoreLocation(World world, BlockPos blockPos) {
        final Wrapper tileLocationWrapper = new Wrapper();
        TileColossalChest.detector.detect(world, blockPos, null, new CubeDetector.IValidationAction(){

            public L10NHelpers.UnlocalizedString onValidate(BlockPos location, IBlockState blockState) {
                if (blockState.func_177230_c() == ColossalChest.getInstance()) {
                    tileLocationWrapper.set((Object)location);
                }
                return null;
            }
        }, false);
        return (BlockPos)tileLocationWrapper.get();
    }

    public static void addPlayerChatError(World world, BlockPos blockPos, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_184586_b(hand) == null) {
            DetectionResult result = TileColossalChest.detector.detect(world, blockPos, null, (CubeDetector.IValidationAction)new MaterialValidationAction(), false);
            if (result != null && result.getError() != null) {
                TextComponentString chat = new TextComponentString("");
                ITextComponent prefix = new TextComponentString(String.format("[%s]: ", L10NHelpers.localize((String)"multiblock.colossalchests.error.prefix"))).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("multiblock.colossalchests.error.prefix.info", new Object[0]))));
                TextComponentString error = new TextComponentString(result.getError().localize());
                chat.func_150257_a(prefix);
                chat.func_150257_a((ITextComponent)error);
                player.func_146105_b((ITextComponent)chat);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(L10NHelpers.localize((String)"multiblock.colossalchests.error.unexpected")));
            }
        }
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (PropertyMaterial.Type material : PropertyMaterial.Type.values()) {
            list.add(new ItemStack((Block)ColossalChest.getInstance(), 1, material.ordinal()));
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.propertyManager = new BlockPropertyManagerComponent((Block)this, (Comparator)new BlockPropertyManagerComponent.PropertyComparator(){

            public int compare(IProperty o1, IProperty o2) {
                return o2.func_177701_a().compareTo(o1.func_177701_a());
            }
        }, (Comparator)new BlockPropertyManagerComponent.UnlistedPropertyComparator());
        return this.propertyManager.createDelegatedBlockState();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta * 2, placer);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float par7, float par8, float par9) {
        if (!((Boolean)blockState.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            ColossalChest.addPlayerChatError(world, blockPos, player, hand);
            return false;
        }
        return super.func_180639_a(world, blockPos, blockState, player, hand, heldItem, side, par7, par8, par9);
    }

    public int func_180651_a(IBlockState state) {
        return ((PropertyMaterial.Type)((Object)state.func_177229_b((IProperty)MATERIAL))).ordinal();
    }

    public boolean isKeepNBTOnDrop() {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && ColossalChest.canPlace(worldIn, pos);
    }

    private static class MaterialValidationAction
    implements CubeDetector.IValidationAction {
        private final Wrapper<PropertyMaterial.Type> requiredMaterial = new Wrapper(null);

        public L10NHelpers.UnlocalizedString onValidate(BlockPos blockPos, IBlockState blockState) {
            PropertyMaterial.Type material = (PropertyMaterial.Type)((Object)BlockHelpers.getSafeBlockStateProperty((IBlockState)blockState, (IProperty)MATERIAL, null));
            if (this.requiredMaterial.get() == null) {
                this.requiredMaterial.set((Object)material);
                return null;
            }
            return this.requiredMaterial.get() == material ? null : new L10NHelpers.UnlocalizedString("multiblock.colossalchests.error.material", new Object[]{material.getLocalizedName(), LocationHelpers.toCompactString((BlockPos)blockPos), ((PropertyMaterial.Type)((Object)this.requiredMaterial.get())).getLocalizedName()});
        }
    }
}

