/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.block.properties.PropertyHelper;
import org.cyclops.cyclopscore.helper.L10NHelpers;

public class PropertyMaterial
extends PropertyHelper<Type> {
    private final ImmutableSet<Type> allowedValues;

    protected PropertyMaterial(String name, Collection<Type> values) {
        super(name, Type.class);
        this.allowedValues = ImmutableSet.copyOf(values);
    }

    public Collection<Type> func_177700_c() {
        return this.allowedValues;
    }

    public Optional<Type> func_185929_b(String value) {
        for (Type type : this.allowedValues) {
            if (!type.toString().equalsIgnoreCase(value)) continue;
            return Optional.of((Object)((Object)type));
        }
        return Optional.absent();
    }

    public String getName(Type value) {
        return value.toString().toLowerCase(Locale.ENGLISH);
    }

    public static PropertyMaterial create(String name, Class clazz) {
        return PropertyMaterial.create(name, clazz, Predicates.alwaysTrue());
    }

    public static PropertyMaterial create(String name, Class clazz, Predicate filter) {
        return PropertyMaterial.create(name, clazz, Collections2.filter((Collection)Lists.newArrayList((Object[])clazz.getEnumConstants()), (Predicate)filter));
    }

    public static PropertyMaterial create(String name, Class clazz, Collection values) {
        return new PropertyMaterial(name, values);
    }

    public static enum Type {
        WOOD(1.0),
        COPPER(1.666),
        IRON(2.0),
        SILVER(2.666),
        GOLD(3.0),
        DIAMOND(4.0);

        private final double inventoryMultiplier;

        private Type(double inventoryMultiplier) {
            this.inventoryMultiplier = inventoryMultiplier;
        }

        public double getInventoryMultiplier() {
            return this.inventoryMultiplier;
        }

        public String getLocalizedName() {
            return L10NHelpers.localize((String)("material.colossalchests." + this.toString().toLowerCase(Locale.ENGLISH)));
        }
    }
}

