/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.tileentity;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.client.render.tileentity.RenderTileEntityModel;
import org.cyclops.cyclopscore.init.ModBase;

public class RenderTileEntityColossalChest
extends RenderTileEntityModel<TileColossalChest, ModelChest> {
    public static final Map<PropertyMaterial.Type, ResourceLocation> TEXTURES = Maps.newHashMap();

    public RenderTileEntityColossalChest(ModelChest model) {
        super((Object)model, null);
    }

    protected void preRotate(TileColossalChest chestTile) {
        if (chestTile.isStructureComplete()) {
            Vec3d renderOffset = chestTile.getRenderOffset();
            GlStateManager.func_179137_b((double)(-renderOffset.field_72450_a), (double)renderOffset.field_72448_b, (double)renderOffset.field_72449_c);
        }
        GlStateManager.func_179109_b((float)0.5f, (float)0.3f, (float)0.5f);
        float size = (float)chestTile.getSizeSingular() * 1.125f;
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
    }

    protected void postRotate(TileColossalChest tile) {
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
    }

    protected void renderModel(TileColossalChest chestTile, ModelChest model, float partialTick, int destroyStage) {
        if (chestTile.isStructureComplete()) {
            this.func_147499_a(TEXTURES.get((Object)chestTile.getMaterial()));
            GlStateManager.func_179094_E();
            if (ColossalChestConfig.chestAnimation) {
                float lidangle = chestTile.prevLidAngle + (chestTile.lidAngle - chestTile.prevLidAngle) * partialTick;
                lidangle = 1.0f - lidangle;
                lidangle = 1.0f - lidangle * lidangle * lidangle;
                model.field_78234_a.field_78795_f = -(lidangle * (float)Math.PI / 2.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            model.func_78231_a();
            GlStateManager.func_179121_F();
        }
    }

    public boolean isGlobalRenderer(TileColossalChest tile) {
        return true;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES.put(PropertyMaterial.Type.WOOD, new ResourceLocation("textures/entity/chest/" + (christmas ? "christmas" : "normal") + ".png"));
        TEXTURES.put(PropertyMaterial.Type.COPPER, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chestCopper.png"));
        TEXTURES.put(PropertyMaterial.Type.IRON, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chestIron.png"));
        TEXTURES.put(PropertyMaterial.Type.SILVER, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chestSilver.png"));
        TEXTURES.put(PropertyMaterial.Type.GOLD, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chestGold.png"));
        TEXTURES.put(PropertyMaterial.Type.DIAMOND, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chestDiamond.png"));
    }
}

