/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.network.packet.WindowItemsFragmentPacket;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;

@ChestContainer(isLargeChest=true)
public class ContainerColossalChest
extends ScrollingInventoryContainer<Slot> {
    private static final int INVENTORY_OFFSET_X = 9;
    private static final int INVENTORY_OFFSET_Y = 112;
    private static final int CHEST_INVENTORY_OFFSET_X = 9;
    private static final int CHEST_INVENTORY_OFFSET_Y = 18;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    private final TileColossalChest tile;
    private final List<Slot> chestSlots;

    public ContainerColossalChest(InventoryPlayer inventory, TileColossalChest tile) {
        super(inventory, (IGuiContainerProvider)ColossalChest.getInstance(), Collections.emptyList(), (ScrollingInventoryContainer.IItemPredicate)new ScrollingInventoryContainer.IItemPredicate<Slot>(){

            public boolean apply(Slot item, Pattern pattern) {
                return true;
            }
        });
        this.tile = tile;
        tile.func_174889_b(inventory.field_70458_d);
        this.chestSlots = Lists.newArrayListWithCapacity((int)tile.func_70302_i_());
        this.addChestSlots(tile.func_70302_i_() / 9, 9);
        this.addPlayerInventory(inventory, 9, 112);
        this.updateFilter("");
    }

    protected List<Slot> getUnfilteredItems() {
        return this.chestSlots;
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = this.makeSlot((IInventory)this.tile, column + row * columns, 9 + column * 18, 18 + row * 18);
                this.func_75146_a(slot);
                this.chestSlots.add(slot);
            }
        }
    }

    protected Slot makeSlot(IInventory inventory, int index, int row, int column) {
        return new SlotExtended(inventory, index, row, column);
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        super.func_75134_a(entityplayer);
        this.tile.func_174886_c(entityplayer);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.canInteractWith(playerIn);
    }

    protected int getSizeInventory() {
        return this.tile.func_70302_i_();
    }

    public int getColumns() {
        return 9;
    }

    public int getPageSize() {
        return 5;
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = Integer.MIN_VALUE;
        slot.field_75221_f = Integer.MIN_VALUE;
    }

    protected void enableSlot(int slotIndex, int row, int column) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = 9 + column * 18;
        slot.field_75221_f = 18 + row * 18;
    }

    protected void onScroll() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
    }

    protected void enableElementAt(int visibleIndex, int elementIndex, Slot element) {
        super.enableElementAt(visibleIndex, elementIndex, (Object)element);
        int column = visibleIndex % this.getColumns();
        int row = (visibleIndex - column) / this.getColumns();
        this.enableSlot(elementIndex, row, column);
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        if (listener instanceof EntityPlayerMP) {
            this.updateCraftingInventory((EntityPlayerMP)listener, this.func_75138_a());
        } else {
            listener.func_71110_a((Container)this, this.func_75138_a());
        }
        this.func_75142_b();
    }

    public void updateCraftingInventory(EntityPlayerMP player, List<ItemStack> allItems) {
        int max = GeneralConfig.maxSlotsPerPacket;
        NetHandlerPlayServer playerNetServerHandler = player.field_71135_a;
        for (int i = 0; i < allItems.size(); i += max) {
            List<ItemStack> items = allItems.subList(i, Math.min(allItems.size(), i + max));
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new WindowItemsFragmentPacket(this.field_75152_c, i, items), player);
        }
        playerNetServerHandler.func_147359_a((Packet)new SPacketSetSlot(-1, -1, player.field_71071_by.func_70445_o()));
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSelection() {
        int i;
        HashMap selection = Maps.newHashMap();
        ArrayList chest = Lists.newArrayList();
        ArrayList playerInventory = Lists.newArrayList();
        for (i = 0; i < this.getSizeInventory(); ++i) {
            chest.add(this.func_75139_a(i));
        }
        for (i = this.getSizeInventory(); i < this.getSizeInventory() + 36; ++i) {
            playerInventory.add(this.func_75139_a(i));
        }
        selection.put(ContainerSection.CHEST, chest);
        selection.put(ContainerSection.INVENTORY, playerInventory);
        return selection;
    }
}

