/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.tileentity;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.CubeSizeValidator;
import org.cyclops.cyclopscore.block.multi.ExactBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.MaximumSizeValidator;
import org.cyclops.cyclopscore.block.multi.MinimumSizeValidator;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntityBase;

public class TileColossalChest
extends InventoryTileEntityBase
implements CyclopsTileEntity.ITickingTile {
    private static final int TICK_MODULUS = 200;
    public static CubeDetector detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)ChestWall.getInstance()), new AllowedBlock((Block)ColossalChest.getInstance()).addCountValidator((IBlockCountValidator)new ExactBlockCountValidator(1)), new AllowedBlock((Block)Interface.getInstance())}, (List)Lists.newArrayList((Object[])new Block[]{ColossalChest.getInstance(), ChestWall.getInstance(), Interface.getInstance()})).addSizeValidator((ISizeValidator)new MinimumSizeValidator(new Vec3i(1, 1, 1))).addSizeValidator((ISizeValidator)new CubeSizeValidator()).addSizeValidator((ISizeValidator)new MaximumSizeValidator(TileColossalChest.getMaxSize()){

        public Vec3i getMaximumSize() {
            return TileColossalChest.getMaxSize();
        }
    });
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private SimpleInventory lastValidInventory = null;
    private SimpleInventory inventory = null;
    @NBTPersist
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.field_177959_e);
    @NBTPersist
    private Vec3d renderOffset = new Vec3d(0.0, 0.0, 0.0);
    @NBTPersist
    private String customName = null;
    @NBTPersist
    private int materialId = 0;
    @NBTPersist
    private int _modVersion = 0;
    private static final int _MOD_VERSION = 1;
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private Block block = ColossalChest.getInstance();
    private EnumFacingMap<int[]> facingSlots = EnumFacingMap.newMap();

    public Vec3i getSize() {
        return this.size;
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.facingSlots.clear();
        if (this.isStructureComplete()) {
            this._modVersion = 1;
            this.inventory = this.constructInventory();
            if (this.lastValidInventory != null) {
                int slot;
                for (slot = 0; slot < Math.min(this.lastValidInventory.func_70302_i_(), this.inventory.func_70302_i_()); ++slot) {
                    ItemStack contents = this.lastValidInventory.func_70301_a(slot);
                    if (contents == null) continue;
                    this.inventory.func_70299_a(slot, contents);
                    this.lastValidInventory.func_70299_a(slot, null);
                }
                if (slot < this.lastValidInventory.func_70302_i_()) {
                    MinecraftHelpers.dropItems((World)this.func_145831_w(), (IInventory)this.lastValidInventory, (BlockPos)this.func_174877_v());
                }
                this.lastValidInventory = null;
            }
        } else {
            if (this.inventory != null) {
                if (GeneralConfig.ejectItemsOnDestroy) {
                    MinecraftHelpers.dropItems((World)this.func_145831_w(), (IInventory)this.inventory, (BlockPos)this.func_174877_v());
                    this.lastValidInventory = null;
                } else {
                    this.lastValidInventory = this.inventory;
                }
            }
            this.inventory = new LargeInventory(0, "invalid", 0);
        }
        this.sendUpdate();
    }

    public void setMaterial(PropertyMaterial.Type material) {
        this.materialId = material.ordinal();
    }

    public PropertyMaterial.Type getMaterial() {
        return PropertyMaterial.Type.values()[this.materialId];
    }

    public int getSizeSingular() {
        return this.getSize().func_177958_n() + 1;
    }

    protected LargeInventory constructInventory() {
        return new LargeInventory(this.calculateInventorySize(), ColossalChestConfig._instance.getNamedId(), 64);
    }

    protected int calculateInventorySize() {
        return (int)Math.ceil(Math.pow(this.getSizeSingular(), 3.0) * 27.0 * this.getMaterial().getInventoryMultiplier());
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b != null && this._modVersion != 1 && this.isStructureComplete()) {
            ColossalChests.clog("Upgrading colossal chest from old mod version at " + this.func_174877_v());
            detector.detect(this.func_145831_w(), this.func_174877_v(), null, new CubeDetector.IValidationAction(){

                public L10NHelpers.UnlocalizedString onValidate(BlockPos location, IBlockState blockState) {
                    TileColossalChest.this.func_145831_w().func_175656_a(location, blockState.func_177226_a((IProperty)ColossalChest.ACTIVE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ColossalChest.MATERIAL, (Comparable)((Object)PropertyMaterial.Type.WOOD)));
                    return null;
                }
            }, false);
            this._modVersion = 1;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (int[])new int[]{this.func_174877_v().hashCode()})) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_174877_v().func_177971_a(new Vec3i((double)(-range), (double)(-range), (double)(-range))), this.func_174877_v().func_177971_a(new Vec3i((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range)))));
            for (EntityPlayer player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.15f / (float)Math.min(5, this.getSizeSingular());
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, (float)(0.5 + 0.5 * Math.log(this.getSizeSingular())), this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.45f + increaseAngle, true);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, (float)(0.5 + 0.5 * Math.log(this.getSizeSingular())), this.field_145850_b.field_73012_v.nextFloat() * 0.05f + 0.45f + increaseAngle, true);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
        super.func_174889_b(entityPlayer);
        this.triggerPlayerUsageChange(1);
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
        super.func_174886_c(entityPlayer);
        this.triggerPlayerUsageChange(-1);
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
    }

    public INBTInventory getInventory() {
        if (this.lastValidInventory != null) {
            return this.lastValidInventory;
        }
        if (this.inventory == null) {
            this.inventory = this.constructInventory();
        }
        return this.inventory;
    }

    protected boolean canAccess(int slot, EnumFacing side) {
        return this.getSizeSingular() > 1 && super.canAccess(slot, side);
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return this.getSizeSingular() > 1 && super.canInteractWith(entityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int size = this.getSizeSingular();
        return new AxisAlignedBB(this.func_174877_v().func_177973_b(new Vec3i(size, size, size)), this.func_174877_v().func_177982_a(size, size * 2, size));
    }

    public void setCenter(Vec3d center) {
        double dx = Math.abs(center.field_72450_a - (double)this.func_174877_v().func_177958_n());
        double dz = Math.abs(center.field_72449_c - (double)this.func_174877_v().func_177952_p());
        boolean equal = center.field_72450_a - (double)this.func_174877_v().func_177958_n() == center.field_72449_c - (double)this.func_174877_v().func_177952_p();
        EnumFacing rotation = dx > dz || !equal && this.getSizeSingular() == 2 ? DirectionHelpers.getEnumFacingFromXSign((int)((int)Math.round(center.field_72450_a - (double)this.func_174877_v().func_177958_n()))) : DirectionHelpers.getEnumFacingFromZSing((int)((int)Math.round(center.field_72449_c - (double)this.func_174877_v().func_177952_p())));
        this.setRotation(rotation);
        this.renderOffset = new Vec3d((double)this.func_174877_v().func_177958_n() - center.field_72450_a, (double)this.func_174877_v().func_177956_o() - center.field_72448_b, (double)this.func_174877_v().func_177952_p() - center.field_72449_c);
    }

    public Vec3d getRenderOffset() {
        return this.renderOffset;
    }

    public static void detectStructure(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slots;
        if (side == null) {
            side = EnumFacing.UP;
        }
        if ((slots = (int[])this.facingSlots.get((Object)side)) == null) {
            ContiguousSet integers = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.func_70302_i_())), (DiscreteDomain)DiscreteDomain.integers());
            slots = ArrayUtils.toPrimitive((Integer[])((Integer[])integers.toArray((Object[])new Integer[integers.size()])));
            this.facingSlots.put((Enum)side, (Object)slots);
        }
        return slots;
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)Vec3i.field_177959_e);
    }

    public static Vec3i getMaxSize() {
        int size = ColossalChestConfig.maxSize;
        return new Vec3i(size, size, size);
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : L10NHelpers.localize((String)"general.colossalchests.colossalchest.name", (Object[])new Object[]{this.getMaterial().getLocalizedName(), this.getSizeSingular()});
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

