/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.gui.CCubesGuiHandler;
import chanceCubes.commands.CCubesCommands;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.hookins.ModHookUtil;
import chanceCubes.items.CCubesItems;
import chanceCubes.listeners.PlayerConnectListener;
import chanceCubes.listeners.TickListener;
import chanceCubes.listeners.WorldGen;
import chanceCubes.network.CCubesPacketHandler;
import chanceCubes.proxy.CommonProxy;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.registry.GiantCubeRegistry;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.CCubesRecipies;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="chancecubes", version="1.10-2.2.1.120", name="Chance Cubes", guiFactory="chanceCubes.config.ConfigGuiFactory", dependencies="required-after:Forge@[12.17.0.1976,)", acceptedMinecraftVersions="[1.10]")
public class CCubesCore {
    public static final String MODID = "chancecubes";
    public static final String VERSION = "1.10-2.2.1.120";
    public static final String NAME = "Chance Cubes";
    public static final String gameVersion = "1.9.4";
    @Mod.Instance(value="chancecubes")
    public static CCubesCore instance;
    @SidedProxy(clientSide="chanceCubes.proxy.ClientProxy", serverSide="chanceCubes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs modTab;
    public static Logger logger;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CCubesRecipies.loadRecipies();
        CCubesSounds.loadSounds();
        if (event.getSide() == Side.CLIENT) {
            CCubesItems.registerItems();
            CCubesBlocks.registerBlocksItems();
        }
        proxy.registerRenderings();
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigLoader.loadConfigSettings(event.getSuggestedConfigurationFile(), event.getSourceFile());
        CCubesBlocks.loadBlocks();
        CCubesItems.loadItems();
        CCubesPacketHandler.init();
        proxy.registerEvents();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerConnectListener());
        MinecraftForge.EVENT_BUS.register((Object)new TickListener());
        MinecraftForge.EVENT_BUS.register((Object)new WorldGen());
        if (CCubesSettings.chestLoot) {
            // empty if block
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CCubesGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ChanceCubeRegistry.loadDefaultRewards();
        GiantCubeRegistry.loadDefaultRewards();
        CustomRewardsLoader.instance.loadCustomRewards();
        CustomRewardsLoader.instance.loadHolidayRewards();
        CustomRewardsLoader.instance.loadDisabledRewards();
        ConfigLoader.config.save();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        ModHookUtil.loadCustomModRewards();
        event.registerServerCommand((ICommand)new CCubesCommands());
    }

    static {
        modTab = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)CCubesBlocks.CHANCE_CUBE);
            }
        };
    }
}

