/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.config;

import chanceCubes.CCubesCore;
import chanceCubes.util.FileUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class CustomSoundsLoader {
    private File folder;
    private File dir;
    private File zip;
    private String name;
    private String mcmeta;
    private List<CustomFile> customsSounds = new ArrayList<CustomFile>();
    private static List<IResourcePack> defaultResourcePacks;
    private static Gson gson;

    public CustomSoundsLoader(File folder, File directory, String packName) {
        this.folder = folder;
        this.dir = directory;
        this.zip = new File(this.dir.getAbsolutePath() + ".zip");
        this.name = packName;
        this.mcmeta = String.format("{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}", this.name);
    }

    public void addCustomSounds() {
        JsonObject root = new JsonObject();
        for (File f : new File(this.folder.getAbsolutePath() + "/Sounds").listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".ogg"))) {
            String simpleName = f.getName().substring(0, f.getName().indexOf(46));
            this.customsSounds.add(new CustomFile("assets/minecraft/sounds", f));
            JsonObject event = new JsonObject();
            event.addProperty("category", "block");
            JsonArray sounds = new JsonArray();
            JsonPrimitive sound = new JsonPrimitive("chancecubes:" + simpleName);
            sounds.add((JsonElement)sound);
            event.add("sounds", (JsonElement)sounds);
            root.add("chancecubes." + simpleName, (JsonElement)event);
        }
        this.customsSounds.add(new CustomFile("assets/minecraft", FileUtil.writeToFile(this.folder.getAbsolutePath() + "/Sounds/sounds.json", gson.toJson((JsonElement)root))));
    }

    public void assemble() {
        FileUtil.safeDeleteDirectory(this.dir);
        this.dir.mkdirs();
        String pathToDir = this.dir.getAbsolutePath();
        File metaFile = new File(pathToDir + "/pack.mcmeta");
        try {
            FileUtil.writeNewFile(metaFile, this.mcmeta);
            for (CustomFile custom : this.customsSounds) {
                File directory = new File(pathToDir + (custom.ext != null ? "/" + custom.ext : ""));
                directory.mkdirs();
                FileUtils.copyFile((File)custom.file, (File)new File(directory.getAbsolutePath() + "/" + custom.file.getName()));
            }
            FileUtil.zipFolderContents(this.dir, this.zip);
            FileUtil.safeDeleteDirectory(this.dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            try {
                if (defaultResourcePacks == null) {
                    defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao", "ap"});
                }
                File dest = new File(this.dir.getParent() + "/Resourcepack/" + this.zip.getName());
                FileUtil.safeDelete(dest);
                FileUtils.copyFile((File)this.zip, (File)dest);
                FileUtil.safeDelete(this.zip);
                FileUtil.writeNewFile(new File(dest.getParent() + "/readme.txt"), "This is the resource pack for loading in custom sounds to chance cubes. Feel free to ignore this file and folder.");
                defaultResourcePacks.add((IResourcePack)new FileResourcePack(dest));
            }
            catch (Exception e) {
                CCubesCore.logger.error("Failed to inject the resource pack for the custom sounds in the Chance Cubes rewards: ", (Throwable)e);
            }
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }

    private class CustomFile {
        private String ext;
        private File file;

        private CustomFile(String ext, File file) {
            this.ext = ext;
            this.file = file;
        }
    }
}

