/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.listeners;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGen {
    @SubscribeEvent
    public void onGenerate(PopulateChunkEvent.Pre event) {
        if (CCubesSettings.isBlockedWorld(event.getWorld().func_72912_H().func_76065_j()) || CCubesSettings.isBlockedWorld("" + event.getWorld().field_73011_w.getDimension())) {
            return;
        }
        if (CCubesSettings.oreGeneration) {
            this.generateOre(event.getWorld(), new Random(), event.getChunkX() * 16, event.getChunkZ() * 16);
        }
        if (CCubesSettings.surfaceGeneration) {
            this.generateSurface(event.getWorld(), new Random(), event.getChunkX() * 16, event.getChunkZ() * 16);
        }
    }

    private void generateOre(World world, Random rand, int x, int z) {
        for (int k = 0; k < CCubesSettings.oreGenAmount; ++k) {
            int firstBlockXCoord = x + rand.nextInt(16);
            int firstBlockYCoord = rand.nextInt(100);
            int firstBlockZCoord = z + rand.nextInt(16);
            new WorldGenMinable(CCubesBlocks.CHANCE_CUBE.func_176223_P(), 3).func_180709_b(world, rand, new BlockPos(firstBlockXCoord, firstBlockYCoord, firstBlockZCoord));
        }
    }

    public void generateSurface(World world, Random rand, int x, int z) {
        if (rand.nextInt(100) < CCubesSettings.surfaceGenAmount) {
            int xCord = x + rand.nextInt(16);
            int zCord = z + rand.nextInt(16);
            int yCord = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
            BlockPos pos = new BlockPos(xCord, yCord - 1, zCord);
            if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150357_h)) {
                for (int y = 0; y < yCord; ++y) {
                    BlockPos pos2 = new BlockPos(xCord, y, zCord);
                    if (!world.func_180495_p(pos).func_177230_c().func_176212_b((IBlockAccess)world, pos2, EnumFacing.UP) || !world.func_175623_d(pos2)) continue;
                    yCord = y;
                    return;
                }
            }
            world.func_175656_a(new BlockPos(xCord, yCord, zCord), CCubesBlocks.CHANCE_CUBE.func_176223_P());
        }
    }
}

