/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.items.ItemChancePendant;
import chanceCubes.registry.IRewardRegistry;
import chanceCubes.rewards.defaultRewards.AnvilRain;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.BlindnessFightReward;
import chanceCubes.rewards.defaultRewards.BookOfMemesReward;
import chanceCubes.rewards.defaultRewards.CakeIsALieReward;
import chanceCubes.rewards.defaultRewards.ChargedCreeperReward;
import chanceCubes.rewards.defaultRewards.ClearInventoryReward;
import chanceCubes.rewards.defaultRewards.CookieMonsterReward;
import chanceCubes.rewards.defaultRewards.CreeperSurroundedReward;
import chanceCubes.rewards.defaultRewards.CustomUserReward;
import chanceCubes.rewards.defaultRewards.DiscoReward;
import chanceCubes.rewards.defaultRewards.EnderCrystalTimerReward;
import chanceCubes.rewards.defaultRewards.FiveProngReward;
import chanceCubes.rewards.defaultRewards.HerobrineReward;
import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.InventoryBombReward;
import chanceCubes.rewards.defaultRewards.ItemOfDestinyReward;
import chanceCubes.rewards.defaultRewards.ItemRenamer;
import chanceCubes.rewards.defaultRewards.JukeBoxReward;
import chanceCubes.rewards.defaultRewards.MathReward;
import chanceCubes.rewards.defaultRewards.MazeReward;
import chanceCubes.rewards.defaultRewards.NukeReward;
import chanceCubes.rewards.defaultRewards.OneIsLuckyReward;
import chanceCubes.rewards.defaultRewards.QuestionsReward;
import chanceCubes.rewards.defaultRewards.RandomTeleportReward;
import chanceCubes.rewards.defaultRewards.RemoveUsefulThingsReward;
import chanceCubes.rewards.defaultRewards.RottenFoodReward;
import chanceCubes.rewards.defaultRewards.SkyblockReward;
import chanceCubes.rewards.defaultRewards.SurroundedReward;
import chanceCubes.rewards.defaultRewards.TableFlipReward;
import chanceCubes.rewards.defaultRewards.ThrownInAirReward;
import chanceCubes.rewards.defaultRewards.TorchesToCreepers;
import chanceCubes.rewards.defaultRewards.TrollHoleReward;
import chanceCubes.rewards.defaultRewards.TrollTNTReward;
import chanceCubes.rewards.defaultRewards.WaitForItReward;
import chanceCubes.rewards.defaultRewards.WitherReward;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.rewardparts.ParticlePart;
import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.type.BlockRewardType;
import chanceCubes.rewards.type.CommandRewardType;
import chanceCubes.rewards.type.EntityRewardType;
import chanceCubes.rewards.type.ExperienceRewardType;
import chanceCubes.rewards.type.IRewardType;
import chanceCubes.rewards.type.ItemRewardType;
import chanceCubes.rewards.type.MessageRewardType;
import chanceCubes.rewards.type.ParticleEffectRewardType;
import chanceCubes.rewards.type.PotionRewardType;
import chanceCubes.rewards.type.SoundRewardType;
import chanceCubes.util.RewardsUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class ChanceCubeRegistry
implements IRewardRegistry {
    public static ChanceCubeRegistry INSTANCE = new ChanceCubeRegistry();
    private static Random random = new Random();
    private Map<String, IChanceCubeReward> nameToReward = Maps.newHashMap();
    private List<IChanceCubeReward> sortedRewards = Lists.newArrayList();
    private Map<String, IChanceCubeReward> disabledNameToReward = Maps.newHashMap();
    private static List<String> oredicts = new ArrayList<String>();
    private static String[] possibleModOres = new String[]{"oreAluminum", "oreCopper", "oreMythril", "oreLead", "orePlutonium", "oreQuartz", "oreRuby", "oreSalt", "oreSapphire", "oreSilver", "oreTin", "oreUranium", "oreZinc"};
    private static List<String> fluids = new ArrayList<String>();
    private static IChanceCubeReward lastReward = null;

    public static void loadDefaultRewards() {
        oredicts.add("oreGold");
        oredicts.add("oreIron");
        oredicts.add("oreLapis");
        oredicts.add("oreDiamond");
        oredicts.add("oreRedstone");
        oredicts.add("oreEmerald");
        oredicts.add("oreQuartz");
        oredicts.add("oreCoal");
        for (String oreDict : possibleModOres) {
            if (!OreDictionary.doesOreNameExist((String)oreDict)) continue;
            oredicts.add(oreDict);
        }
        for (String s : FluidRegistry.getRegisteredFluids().keySet()) {
            fluids.add(s);
        }
        if (!CCubesSettings.enableHardCodedRewards) {
            return;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Tnt_Structure", -30, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150335_W, -1, 0, -1, true, 0, false, false), RewardsUtil.fillArea(3, 1, 3, Blocks.field_150451_bX, -1, 1, -1, true, 30, false, false)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:BedRock", -20, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150357_h, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Redstone_Diamond", 10, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151137_ax)), new ItemPart(new ItemStack(Items.field_151045_i)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Sethbling_Reward", 30, new MessageRewardType(new MessagePart("Welcome back, SethBling here :)")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151137_ax, 32)), new ItemPart(new ItemStack(Items.field_151107_aW, 3)), new ItemPart(new ItemStack(Items.field_151132_bS, 3)), new ItemPart(new ItemStack(Blocks.field_150379_bu, 3)), new ItemPart(new ItemStack(Blocks.field_150429_aA, 3)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:EXP", 35, new ExperienceRewardType(new ExpirencePart(100).setNumberofOrbs(10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:EXP_Shower", 35, new ExperienceRewardType(new ExpirencePart(10), new ExpirencePart(10, 10), new ExpirencePart(10, 10), new ExpirencePart(10, 20), new ExpirencePart(10, 30), new ExpirencePart(10, 40), new ExpirencePart(10, 50), new ExpirencePart(10, 60), new ExpirencePart(10, 70), new ExpirencePart(10, 80), new ExpirencePart(10, 90), new ExpirencePart(10, 100), new ExpirencePart(10, 110), new ExpirencePart(10, 120), new ExpirencePart(10, 130), new ExpirencePart(10, 140), new ExpirencePart(10, 150))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Poison", -25, new PotionRewardType(new PotionPart(new PotionEffect(MobEffects.field_76436_u, 500)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:ChatMessage", 0, new MessageRewardType(new MessagePart("You have escaped the wrath of the Chance Cubes........."), new MessagePart("For now......"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Hearts", 0, new ParticleEffectRewardType(RewardsUtil.spawnXParticles(34, 5))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Explosion", 0, new ParticleEffectRewardType(new ParticlePart(2)), new SoundRewardType(new SoundPart(SoundEvents.field_187539_bB))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Wool", 25, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 0)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 1)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 2)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 3)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 4)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 5)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 6)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 7)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 8)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 9)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 10)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 11)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 12)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 13)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 14)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 15)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Enchanting", 80, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150381_bn)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bookshelves", 60, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150342_X, 8)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Ores_Galore", 50, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151044_h)), new ItemPart(new ItemStack(Items.field_151137_ax)), new ItemPart(new ItemStack(Items.field_151042_j)), new ItemPart(new ItemStack(Items.field_151043_k)), new ItemPart(new ItemStack(Items.field_151045_i)), new ItemPart(new ItemStack(Items.field_151166_bC)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Have_Another", 0, new ItemRewardType(new ItemPart(new ItemStack((Block)CCubesBlocks.CHANCE_CUBE, 3))), new MessageRewardType(new MessagePart("I hear you like Chance Cubes."), new MessagePart("So I put some Chance Cubes in your Chance Cubes!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Icsahedron", 0, new ItemRewardType(new ItemPart(new ItemStack((Block)CCubesBlocks.CHANCE_ICOSAHEDRON)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Saplings", 35, new MessageRewardType(new MessagePart("Seems you have purchased the saplings DLC")), new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 0)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 1)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 2)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 3)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 4)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 5)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Farmer", 35, new MessageRewardType(new MessagePart("Time to farm!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151019_K)), new ItemPart(new ItemStack(Items.field_151133_ar)), new ItemPart(new ItemStack(Items.field_151014_N, 16)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Rancher", 60, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_180407_aO, 32)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 90)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 91)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 92)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fighter", 25, new MessageRewardType(new MessagePart("SPARTAAA!!!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151040_l)), new ItemPart(new ItemStack((Item)Items.field_151028_Y)), new ItemPart(new ItemStack((Item)Items.field_151030_Z)), new ItemPart(new ItemStack((Item)Items.field_151165_aa)), new ItemPart(new ItemStack((Item)Items.field_151167_ab)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:pssst", -5, new MessageRewardType(new MessagePart("Pssssst.... Over here!")), new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("Creeper")))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Explorer", 30, new MessageRewardType(new MessagePart("Lets go on a journey!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151111_aL)), new ItemPart(new ItemStack(Items.field_151113_aN)), new ItemPart(new ItemStack(Blocks.field_150478_aa, 64)), new ItemPart(new ItemStack(Items.field_151035_b)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Mitas", 50, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151074_bl, 32)), new ItemPart(new ItemStack(Items.field_151043_k, 8)), new ItemPart(new ItemStack(Items.field_151150_bK, 16)), new ItemPart(new ItemStack((Item)Items.field_151169_ag)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Horde", -25, new MessageRewardType(new MessagePart("Release the horde!")), new EntityRewardType(RewardsUtil.spawnXEntities(EntityRewardType.getBasicNBTForEntity("Zombie"), 15))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Lava_Ring", -40, new BlockRewardType(new OffsetBlock(1, -1, 0, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, 1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 0, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, -1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, -1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, -1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Rain", -5, new CommandRewardType(new CommandPart("/weather thunder 20000"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Silverfish_Surround", -20, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(1, 1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, 1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, 1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(-1, 0, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(-1, 1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, -1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, -1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 2, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fish_Dog", 20, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151115_aP, 5))), new CommandRewardType(new CommandPart("/summon Item %x %y %z {Item:{id:spawn_egg,Damage:95,Count:1,tag:{EntityTag:{id:\"Wolf\"}}}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bone_Cat", 20, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151103_aS, 5))), new CommandRewardType(new CommandPart("/summon Item %x %y %z {Item:{id:spawn_egg,Damage:95,Count:1,tag:{EntityTag:{id:\"Ozelot\"}}}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:XP_Crystal", -60, new CommandRewardType(new CommandPart("/summon XPOrb ~ ~1 ~ {Value:1,Passengers:[{id:\"EnderCrystal\"}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Cat", -25, new CommandRewardType(new CommandPart("/summon Ozelot ~ ~1 ~ {CatType:0,Sitting:0,Passengers:[{id:\"PrimedTnt\",Fuse:80}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:SlimeMan", 10, new CommandRewardType(new CommandPart("/summon Slime ~ ~1 ~ {Size:3,Glowing:1b,Passengers:[{id:\"Slime\",Size:2,Glowing:1b,Passengers:[{id:\"Slime\",CustomName:\"Slime Man\",CustomNameVisible:1,Size:1,Glowing:1b}]}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Sail_Away", 5, new BlockRewardType(new OffsetBlock(0, -1, 0, (Block)Blocks.field_150355_j, false)), new CommandRewardType(new CommandPart("/summon Boat %x %y %z")), new MessageRewardType(new MessagePart("Come sail away!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Witch", -15, new CommandRewardType(new CommandPart("/summon Witch %x %y %z "))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Cluckington", 40, new CommandRewardType(new CommandPart("/summon Chicken ~ ~1 ~ {CustomName:\"Cluckington\",CustomNameVisible:1,ActiveEffects:[{Id:1,Amplifier:3,Duration:199980}],Passengers:[{id:\"Zombie\",CustomName:\"Wyld\",CustomNameVisible:1,IsVillager:0,IsBaby:1}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Jerry", 40, new CommandRewardType(new CommandPart("/summon Slime %x %y %z {Size:1,CustomName:\"Jerry\",CustomNameVisible:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Glenn", 40, new CommandRewardType(new CommandPart("/summon Zombie %x %y %z {CustomName:\"Glenn\",CustomNameVisible:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Dr_Trayaurus", 40, new CommandRewardType(new CommandPart("/summon Villager %x %y %z {CustomName:\"Dr Trayaurus\",CustomNameVisible:1,Profession:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Pickles", 40, new CommandRewardType(new CommandPart("/summon MushroomCow ~ ~1 ~ {Age:-10000,CustomName:\"Pickles\"}")), new MessageRewardType(new MessagePart("Why is his name pickles? The world may neve know"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Want_To_Build_A_Snowman", 45, new MessageRewardType(new MessagePart("Do you want to build a snowman?")), new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150433_aE, 2)), new ItemPart(new ItemStack(Blocks.field_150423_aK)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Diamond_Block", 85, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150484_ah, true, 200))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Diamond", -35, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, -1, 0, Blocks.field_150484_ah, false), new OffsetBlock(1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(-1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, 1, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, -1, Blocks.field_150484_ah, false)), new CommandRewardType(new CommandPart("/summon PrimedTnt %x %y %z {Fuse:40}"), new CommandPart("/summon PrimedTnt %x %y %z {Fuse:40}"), new CommandPart("/summon PrimedTnt %x %y %z {Fuse:40}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Anti_Slab", -15, new BlockRewardType(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150343_Z, -1, 2, -1, false, 0, false, true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Chance_Cube_Cube", -10, new MessageRewardType(new MessagePart("Hey, at least it isn't a Giant Chance Cube >:)")), new BlockRewardType(new OffsetBlock(-1, 0, -1, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-1, 0, -2, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-2, 0, -1, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-2, 0, -2, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-1, 1, -1, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-1, 1, -2, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-2, 1, -1, CCubesBlocks.CHANCE_CUBE, false), new OffsetBlock(-2, 1, -2, CCubesBlocks.CHANCE_CUBE, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fake_TNT", 0, new SoundRewardType(new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187539_bB).setDelay(120).setAtPlayersLocation(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invisible_Ghasts", 0, new SoundRewardType(new SoundPart(SoundEvents.field_189105_bM).setServerWide(true), new SoundPart(SoundEvents.field_187559_bL).setServerWide(true), new SoundPart(SoundEvents.field_187559_bL).setServerWide(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:No", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, CCubesBlocks.CHANCE_CUBE, false)), new MessageRewardType(new MessagePart("No"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invisible_Creeper", -30, new CommandRewardType(new CommandPart("/summon Creeper %x %y %z {ActiveEffects:[{Id:14,Amplifier:0,Duration:200,ShowParticles:0b}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Knockback_Zombie", -35, new CommandRewardType(new CommandPart("/summon Zombie ~ ~1 ~ {CustomName:\"Leonidas\",CustomNameVisible:1,IsVillager:0,IsBaby:1,HandItems:[{id:stick,Count:1,tag:{AttributeModifiers:[{AttributeName:\"generic.knockbackResistance\",Name:\"generic.knockbackResistance\",Amount:100,Operation:0,UUIDLeast:724513,UUIDMost:715230}],ench:[{id:19,lvl:100}],display:{Name:\"The Spartan Kick\"}}},{}],HandDropChances:[0.0F,0.085F],ActiveEffects:[{Id:1,Amplifier:5,Duration:199980,ShowParticles:0b},{Id:8,Amplifier:2,Duration:199980}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Actual_Invisible_Ghast", -80, new CommandRewardType(new CommandPart("/summon Ghast ~ ~10 ~ {ActiveEffects:[{Id:14,Amplifier:0,Duration:2000,ShowParticles:0b}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Giant_Chance_Cube", -45, new BlockRewardType(RewardsUtil.fillArea(3, 3, 3, CCubesBlocks.CHANCE_CUBE, -1, 0, -1, false, 0, true, false))), false);
        INSTANCE.registerReward(new BasicReward("chancecubes:Fireworks", 0, new CommandRewardType(RewardsUtil.executeXCommands("/summon FireworksRocketEntity ~ ~1 ~ {FireworksItem:{id:fireworks,Count:1,tag:{Fireworks:{Explosions:[{Type:0,Colors:[16711680],FadeColors:[16711680]}]}}}}", 4))));
        INSTANCE.registerReward(new BasicReward("chancecubes:STRING!", 7, new BlockRewardType(RewardsUtil.fillArea(11, 5, 11, Blocks.field_150473_bD, -5, 0, -5, false, 0, false, true)), new MessageRewardType(new MessagePart("STRING!!!!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Bats", -50, new CommandRewardType(RewardsUtil.executeXCommands("/summon Bat ~ ~1 ~ {Passengers:[{id:\"PrimedTnt\",Fuse:80}]}", 10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Nether_Jelly_Fish", -40, new CommandRewardType(RewardsUtil.executeXCommands("/summon Bat ~ ~1 ~ {Passengers:[{id:\"LavaSlime\",CustomName:\"Nether Jelly Fish\",CustomNameVisible:1,Size:3}]}", 10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Pig_Of_Destiny", 15, new CommandRewardType(new CommandPart("/summon Pig ~ ~1 ~ {CustomName:\"The Pig of Destiny\",CustomNameVisible:1,ArmorItems:[{},{},{id:diamond_chestplate,Count:1,tag:{ench:[{id:7,lvl:1000}]}},{}],ArmorDropChances:[0.085F,0.085F,0.0F,0.085F]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Squid_Horde", 5, new MessageRewardType(new MessagePart("Release the horde!").setRange(32), new MessagePart("Of squids!!").setDelay(20).setRange(32)), new EntityRewardType(RewardsUtil.spawnXEntities(EntityRewardType.getBasicNBTForEntity("Squid"), 15)), new BlockRewardType(RewardsUtil.fillArea(3, 2, 3, (Block)Blocks.field_150355_j, -1, 0, -1, false, 5, true, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:D-rude_SandStorm", -10, new BlockRewardType(RewardsUtil.fillArea(5, 3, 5, (Block)Blocks.field_150354_m, -2, 0, -2, true, 0, false, true)), new MessageRewardType(new MessagePart("Well that was D-rude").setDelay(40))));
        INSTANCE.registerReward(new BasicReward("chancecubes:DIY_Pie", 5, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.field_150423_aK, false), new OffsetBlock(1, 1, 0, (Block)Blocks.field_150436_aH, false)), new CommandRewardType(new CommandPart("/summon Chicken ~ ~1 ~ {CustomName:\"Zeeth_Kyrah\",CustomNameVisible:1}")), new MessageRewardType(new MessagePart("Do it yourself Pumpkin Pie!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Watch_World_Burn", -5, new BlockRewardType(RewardsUtil.fillArea(7, 1, 7, (Block)Blocks.field_150480_ab, -3, 0, -3, false, 0, true, true)), new MessageRewardType(new MessagePart("Some people just want to watch the world burn."))));
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStack stack = new ItemStack(Items.field_151055_y);
        stack.func_77966_a(Enchantment.func_180305_b((String)"sharpness"), 5);
        stack.func_151001_c("A Big Stick");
        INSTANCE.registerReward(new BasicReward("chancecubes:Roosevelt's_Stick", 70, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151112_aM);
        stack.func_77964_b(stack.func_77958_k() / 2);
        INSTANCE.registerReward(new BasicReward("chancecubes:Half_Fishingrod", 5, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151153_ao, 1, 1);
        stack.func_151001_c("Notch");
        INSTANCE.registerReward(new BasicReward("chancecubes:Notch", 70, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151156_bN);
        stack.func_151001_c("North Star");
        INSTANCE.registerReward(new BasicReward("chancecubes:Nether_Star", 100, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151048_u);
        stack.func_77966_a(Enchantment.func_180305_b((String)"sharpness"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"unbreaking"), 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Sword");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine", 85, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151039_o);
        stack.func_77966_a(Enchantment.func_180305_b((String)"efficiency"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"fortune"), 3);
        stack.func_151001_c("Giga Breaker");
        INSTANCE.registerReward(new BasicReward("chancecubes:Giga_Breaker", 70, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151031_f);
        stack.func_77964_b(stack.func_77958_k());
        stack.func_77966_a(Enchantment.func_180305_b((String)"power"), 5);
        stack.func_77966_a(Enchantment.func_180305_b((String)"punch"), 3);
        stack.func_77966_a(Enchantment.func_180305_b((String)"flame"), 2);
        INSTANCE.registerReward(new BasicReward("chancecubes:One_Shot", 75, new ItemRewardType(new ItemPart(stack), new ItemPart(new ItemStack(Items.field_151032_g, 1)))));
        stack = new ItemStack(Items.field_151115_aP, 1, 2);
        stack.func_151001_c("Nemo");
        INSTANCE.registerReward(new BasicReward("chancecubes:Finding_Nemo", 10, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151115_aP, 1, 2);
        stack.func_151001_c("Marlin");
        INSTANCE.registerReward(new BasicReward("chancecubes:Finding_Marlin", 10, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Block)Blocks.field_150480_ab, 1);
        stack.func_77966_a(Enchantment.func_180305_b((String)"fire_aspect"), 2);
        stack.func_151001_c("Why not?");
        INSTANCE.registerReward(new BasicReward("chancecubes:Fire_Aspect_Fire", 60, new ItemRewardType(new ItemPart(stack))));
        TileEntitySign sign = new TileEntitySign();
        sign.field_145915_a[0] = new TextComponentString("The broken path");
        sign.field_145915_a[1] = new TextComponentString("to succeed");
        nbt = new NBTTagCompound();
        sign.func_189515_b(nbt);
        INSTANCE.registerReward(new BasicReward("chancecubes:Path_To_Succeed", 0, new BlockRewardType(new OffsetBlock[]{new OffsetTileEntity(0, 0, -5, Blocks.field_150472_an, nbt, true, 20), new OffsetBlock(0, -1, 0, Blocks.field_150347_e, true, 0), new OffsetBlock(0, -1, -1, Blocks.field_150347_e, true, 4), new OffsetBlock(0, -1, -2, Blocks.field_150347_e, true, 8), new OffsetBlock(0, -1, -3, Blocks.field_150347_e, true, 12), new OffsetBlock(0, -1, -4, Blocks.field_150347_e, true, 16), new OffsetBlock(0, -1, -5, Blocks.field_150347_e, true, 20)})));
        OffsetTileEntity[] signs = new OffsetTileEntity[4];
        for (int i = 0; i < signs.length; ++i) {
            sign = new TileEntitySign();
            sign.field_145915_a[0] = new TextComponentString("Help Me!");
            nbt = new NBTTagCompound();
            sign.func_189515_b(nbt);
            OffsetTileEntity temp = new OffsetTileEntity(i == 2 ? -2 : (i == 3 ? 2 : 0), 1, i == 0 ? -2 : (i == 1 ? 2 : 0), Blocks.field_150444_as, nbt, false, 5);
            temp.setBlockState(Blocks.field_150444_as.func_176223_P().func_177226_a((IProperty)BlockWallSign.field_176412_a, (Comparable)EnumFacing.func_82600_a((int)(i + 2))));
            signs[i] = temp;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Help_Me", 0, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150417_aV, -1, -1, -1, false, 0, true, false), RewardsUtil.fillArea(3, 3, 3, Blocks.field_150411_aY, -1, 0, -1, false, 0, true, false), RewardsUtil.fillArea(1, 3, 1, Blocks.field_150350_a, 0, 0, 0, false, 1, true, false), signs)), new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("Villager")).setRemovedBlocks(false).setDelay(5)), new CommandRewardType(new CommandPart("/summon PrimedTnt %x %y %z {Fuse:80}", 5))));
        OffsetBlock[] blocks = new OffsetBlock[35];
        int i = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (y == 1 && (x == 0 || x == 4 || z == 0 || z == 4)) continue;
                    blocks[i] = new OffsetBlock(x - 2, y, z - 2, Blocks.field_150339_S, true, i * 5);
                    ++i;
                }
            }
        }
        blocks[i] = new OffsetBlock(0, 2, 0, (Block)Blocks.field_150461_bJ, true, 200);
        INSTANCE.registerReward(new BasicReward("chancecubes:Beacon_Build", 100, new BlockRewardType(blocks)));
        INSTANCE.registerReward(new BasicReward("chancecubes:No_Exp", -40, new IRewardType[0]){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                player.field_71068_ca = 0;
                player.field_71067_cb = 0;
                player.func_145747_a((ITextComponent)new TextComponentString("Screw you last stand"));
            }
        });
        INSTANCE.registerReward(new BasicReward("chancecubes:Smite", -10, new IRewardType[0]){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, false));
                player.func_145747_a((ITextComponent)new TextComponentString("Thou has been smitten!"));
            }
        });
        INSTANCE.registerReward(new NukeReward());
        INSTANCE.registerReward(new FiveProngReward());
        INSTANCE.registerReward(new AnvilRain());
        INSTANCE.registerReward(new HerobrineReward());
        INSTANCE.registerReward(new SurroundedReward());
        INSTANCE.registerReward(new CreeperSurroundedReward());
        INSTANCE.registerReward(new RandomTeleportReward());
        INSTANCE.registerReward(new TrollHoleReward());
        INSTANCE.registerReward(new CookieMonsterReward());
        INSTANCE.registerReward(new BlindnessFightReward());
        INSTANCE.registerReward(new WitherReward());
        INSTANCE.registerReward(new TrollTNTReward());
        INSTANCE.registerReward(new EnderCrystalTimerReward());
        INSTANCE.registerReward(new WaitForItReward());
        INSTANCE.registerReward(new ChargedCreeperReward());
        INSTANCE.registerReward(new ClearInventoryReward(), false);
        INSTANCE.registerReward(new ItemOfDestinyReward());
        INSTANCE.registerReward(new ThrownInAirReward());
        INSTANCE.registerReward(new DiscoReward());
        INSTANCE.registerReward(new InventoryBombReward());
        INSTANCE.registerReward(new JukeBoxReward());
        INSTANCE.registerReward(new BookOfMemesReward());
        INSTANCE.registerReward(new RemoveUsefulThingsReward());
        INSTANCE.registerReward(new TableFlipReward());
        INSTANCE.registerReward(new TorchesToCreepers());
        INSTANCE.registerReward(new MazeReward());
        INSTANCE.registerReward(new RottenFoodReward());
        INSTANCE.registerReward(new OneIsLuckyReward());
        INSTANCE.registerReward(new SkyblockReward());
        INSTANCE.registerReward(new CakeIsALieReward());
        INSTANCE.registerReward(new ItemRenamer());
        INSTANCE.registerReward(new BasicReward("chancecubes:Half_Heart", -30, new IRewardType[0]){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                player.func_70606_j(1.0f);
            }
        });
        MathReward math = new MathReward();
        MinecraftForge.EVENT_BUS.register((Object)math);
        INSTANCE.registerReward(math);
        QuestionsReward question = new QuestionsReward();
        MinecraftForge.EVENT_BUS.register((Object)question);
        INSTANCE.registerReward(question);
    }

    public static void loadCustomUserRewards(MinecraftServer server) {
        ArrayList<EntityPlayerMP> allp = new ArrayList<EntityPlayerMP>();
        for (int i = 0; i < server.field_71305_c.length; ++i) {
            ListIterator iterator = server.field_71305_c[i].field_73010_i.listIterator();
            while (iterator.hasNext()) {
                allp.add((EntityPlayerMP)iterator.next());
            }
        }
        for (EntityPlayerMP player : allp) {
            new CustomUserReward((EntityPlayer)player);
        }
    }

    @Override
    public void registerReward(IChanceCubeReward reward) {
        this.registerReward(reward, true);
    }

    public void registerReward(IChanceCubeReward reward, boolean enabledDefault) {
        if (ConfigLoader.config.getBoolean(reward.getName(), "Rewards", enabledDefault, "") && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), reward);
            this.redoSort(reward);
        } else {
            this.disabledNameToReward.put(reward.getName(), reward);
        }
    }

    public boolean enableReward(String reward) {
        if (this.disabledNameToReward.containsKey(reward)) {
            return this.enableReward(this.disabledNameToReward.get(reward));
        }
        return false;
    }

    public boolean enableReward(IChanceCubeReward reward) {
        this.disabledNameToReward.remove(reward.getName());
        this.nameToReward.put(reward.getName(), reward);
        this.redoSort(reward);
        return true;
    }

    @Override
    public boolean unregisterReward(String name) {
        IChanceCubeReward reward = this.nameToReward.remove(name);
        if (reward != null) {
            this.disabledNameToReward.put(name, reward);
            return this.sortedRewards.remove(reward);
        }
        return false;
    }

    @Override
    public IChanceCubeReward getRewardByName(String name) {
        return this.nameToReward.get(name);
    }

    @Override
    public void triggerRandomReward(World world, BlockPos pos, EntityPlayer player, int chance) {
        int upperRange;
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with ChanceCubes and no reward was able to be given");
            return;
        }
        if (CCubesSettings.doesHolidayRewardTrigger && CCubesSettings.holidayReward != null) {
            CCubesSettings.holidayReward.trigger(world, pos, player);
            CCubesSettings.doesHolidayRewardTrigger = false;
            CCubesSettings.holidayRewardTriggered = true;
            ConfigLoader.config.get("General Settings", "HolidayRewardTriggered", false, "Don't touch! Well I mean you can touch it, if you want. I can't stop you. I'm only text.").setValue(true);
            ConfigLoader.config.save();
            return;
        }
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = player.field_71071_by.field_70462_a[i];
                if (stack == null || !(stack.func_77973_b() instanceof ItemChancePendant)) continue;
                ItemChancePendant pendant = (ItemChancePendant)stack.func_77973_b();
                pendant.damage(stack);
                if (stack.func_77952_i() >= CCubesSettings.pendantUses) {
                    player.field_71071_by.func_70299_a(i, null);
                }
                if ((chance += pendant.getChanceIncrease()) <= 100) break;
                chance = 100;
                break;
            }
        }
        int lowerIndex = 0;
        int upperIndex = this.sortedRewards.size() - 1;
        int lowerRange = chance - CCubesSettings.rangeMin < -100 ? -100 : chance - CCubesSettings.rangeMin;
        int n = upperRange = chance + CCubesSettings.rangeMax > 100 ? 100 : chance + CCubesSettings.rangeMax;
        while (this.sortedRewards.get(lowerIndex).getChanceValue() < lowerRange) {
            if (++lowerIndex < this.sortedRewards.size()) continue;
            --lowerIndex;
            break;
        }
        while (this.sortedRewards.get(upperIndex).getChanceValue() > upperRange) {
            if (--upperIndex >= 0) continue;
            ++upperIndex;
            break;
        }
        int range = upperIndex - lowerIndex > 0 ? upperIndex - lowerIndex : 1;
        int pick = random.nextInt(range) + lowerIndex;
        IChanceCubeReward pickedReward = this.sortedRewards.get(pick);
        if (lastReward != null) {
            for (int atempts = 0; atempts < 5 && lastReward.getName().equals(pickedReward.getName()); atempts = (int)((byte)(atempts + 1))) {
                pick = random.nextInt(range) + lowerIndex;
                pickedReward = this.sortedRewards.get(pick);
            }
        }
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + pickedReward.getName());
        pickedReward.trigger(world, pos, player);
        lastReward = pickedReward;
    }

    private void redoSort(@Nullable IChanceCubeReward newReward) {
        if (newReward != null) {
            this.sortedRewards.add(newReward);
        }
        Collections.sort(this.sortedRewards, new Comparator<IChanceCubeReward>(){

            @Override
            public int compare(IChanceCubeReward o1, IChanceCubeReward o2) {
                return o1.getChanceValue() - o2.getChanceValue();
            }
        });
    }

    public void ClearRewards() {
        this.sortedRewards.clear();
        this.nameToReward.clear();
        this.disabledNameToReward.clear();
    }

    public static String getRandomOreDict() {
        return oredicts.get(random.nextInt(oredicts.size()));
    }

    public static Fluid getRandomFluid() {
        Fluid f = FluidRegistry.getFluid((String)fluids.get(random.nextInt(fluids.size())));
        while (f == null || f.getBlock() == null) {
            f = FluidRegistry.getFluid((String)fluids.get(random.nextInt(fluids.size())));
        }
        return f;
    }
}

