/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.IBioDomeBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BasicTreesBiome
implements IBioDomeBiome {
    private Random rand = new Random();

    @Override
    public Block getFloorBlock() {
        return Blocks.field_150349_c;
    }

    @Override
    public void getRandomGenBlock(float dist, Random rand, int x, int y, int z, List<OffsetBlock> blocks, int delay) {
        if (y != 0) {
            return;
        }
        if (dist < 0.0f && rand.nextInt(5) == 0) {
            OffsetBlock osb = new OffsetBlock(x, y + 1, z, (Block)Blocks.field_150329_H, false, delay / 10);
            osb.setBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS));
            blocks.add(osb);
        } else if (dist < -5.0f && rand.nextInt(100) == 0) {
            List<OffsetBlock> treeblocks = this.addTree(x, y, z, delay / 10);
            blocks.addAll(treeblocks);
        }
    }

    public List<OffsetBlock> addTree(int x, int y, int z, int delay) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (int yy = 1; yy < 6; ++yy) {
            blocks.add(new OffsetBlock(x, y + yy, z, Blocks.field_150364_r, false, delay));
            ++delay;
        }
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 0; yy < 2; ++yy) {
                    if (xx == 0 && zz == 0) continue;
                    blocks.add(new OffsetBlock(x + xx, y + 4 + yy, z + zz, (Block)Blocks.field_150362_t, false, delay));
                    ++delay;
                }
            }
        }
        blocks.add(new OffsetBlock(x + 1, y + 6, z, (Block)Blocks.field_150362_t, false, delay));
        blocks.add(new OffsetBlock(x - 1, y + 6, z, (Block)Blocks.field_150362_t, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z + 1, (Block)Blocks.field_150362_t, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z - 1, (Block)Blocks.field_150362_t, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z, (Block)Blocks.field_150362_t, false, ++delay));
        ++delay;
        return blocks;
    }

    @Override
    public void spawnEntities(BlockPos center, World world) {
        for (int i = 0; i < this.rand.nextInt(10) + 5; ++i) {
            int ri = this.rand.nextInt(5);
            if (ri == 0) {
                EntityChicken chicken = new EntityChicken(world);
                chicken.func_70012_b((double)(center.func_177958_n() + (this.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)chicken);
                continue;
            }
            if (ri == 1) {
                EntityCow cow = new EntityCow(world);
                cow.func_70012_b((double)(center.func_177958_n() + (this.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)cow);
                continue;
            }
            if (ri == 2) {
                EntityHorse horse = new EntityHorse(world);
                horse.func_70012_b((double)(center.func_177958_n() + (this.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)horse);
                continue;
            }
            if (ri == 3) {
                EntityPig pig = new EntityPig(world);
                pig.func_70012_b((double)(center.func_177958_n() + (this.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)pig);
                continue;
            }
            if (ri != 4) continue;
            EntitySheep sheep = new EntitySheep(world);
            sheep.func_70012_b((double)(center.func_177958_n() + (this.rand.nextInt(31) - 15)), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
            world.func_72838_d((Entity)sheep);
        }
    }
}

