/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import org.apache.logging.log4j.Level;

public class CustomUserReward
implements IChanceCubeReward {
    private String userName = "";
    private UUID uuid = null;
    private String type;
    private List<BasicReward> customRewards = new ArrayList<BasicReward>();

    public CustomUserReward(EntityPlayer player) {
        JsonElement userRewards;
        JsonElement users;
        if (!CCubesSettings.userSpecificRewards) {
            return;
        }
        try {
            users = HTTPUtil.getWebFile(CCubesSettings.rewardURL + "/UserList.json");
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the list of users with custom rewards!");
            return;
        }
        UUID uuidTemp = this.getPlayerUUID(player.func_70005_c_());
        if (uuidTemp == null) {
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the uuid of the user!");
            return;
        }
        for (JsonElement user : users.getAsJsonArray()) {
            if (!user.getAsJsonObject().get("UUID").getAsString().equalsIgnoreCase(uuidTemp.toString())) continue;
            this.userName = user.getAsJsonObject().get("Name").getAsString();
            this.uuid = uuidTemp;
            this.type = user.getAsJsonObject().get("Type").getAsString();
        }
        if (this.userName.equals("")) {
            CCubesCore.logger.log(Level.INFO, "No custom rewards detected for the current user!");
            return;
        }
        try {
            userRewards = HTTPUtil.getWebFile(CCubesSettings.rewardURL + "/Users/" + this.userName + ".json");
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the custom list for " + this.userName + "!");
            CCubesCore.logger.log(Level.ERROR, e.getMessage());
            return;
        }
        for (Map.Entry reward : userRewards.getAsJsonObject().entrySet()) {
            this.customRewards.add(CustomRewardsLoader.instance.parseReward(reward));
        }
        ChanceCubeRegistry.INSTANCE.registerReward(this);
        player.func_145747_a((ITextComponent)new TextComponentString("Seems you have some custom Chance Cubes rewards " + this.userName + "...."));
        player.func_145747_a((ITextComponent)new TextComponentString("Let the fun begin! >:)"));
    }

    @Override
    public void trigger(final World world, final BlockPos pos, final EntityPlayer player) {
        if (!UsernameCache.getLastKnownUsername((UUID)this.uuid).equalsIgnoreCase(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Hey you aren't " + this.userName + "! You can't have their reward! Try again!"));
            EntityItem itemEnt = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)CCubesBlocks.CHANCE_CUBE, 1));
            world.func_72838_d((Entity)itemEnt);
            return;
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Selecting best (possibly deadly) reward for " + this.type + " " + this.userName));
        Task task = new Task("Custom Reward", 100){

            @Override
            public void callback() {
                CustomUserReward.this.triggerAcutalReward(world, pos, player);
            }
        };
        Scheduler.scheduleTask(task);
    }

    public void triggerAcutalReward(World world, BlockPos pos, EntityPlayer player) {
        this.customRewards.get(world.field_73012_v.nextInt(this.customRewards.size())).trigger(world, pos, player);
    }

    @Override
    public int getChanceValue() {
        return 0;
    }

    @Override
    public String getName() {
        return "chancecubes:CR_" + this.userName;
    }

    public UUID getPlayerUUID(String username) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }
}

