/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemOfDestinyReward
implements IChanceCubeReward {
    private Random rand = new Random();

    @Override
    public void trigger(World world, BlockPos pos, final EntityPlayer player) {
        final EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(this.randomItem(), 1));
        item.func_174867_a(100000);
        world.func_72838_d((Entity)item);
        player.func_145747_a((ITextComponent)new TextComponentString("Selecting random item"));
        Task task = new Task("Item_Of_Destiny_Reward", 5){

            @Override
            public void callback() {
                ItemOfDestinyReward.this.changeItem(item, 0, player);
            }
        };
        Scheduler.scheduleTask(task);
    }

    private void changeItem(final EntityItem item, final int iteration, final EntityPlayer player) {
        Task task = new Task("Item_Of_Destiny_Reward", 5){

            @Override
            public void callback() {
                if (iteration + 1 > 17) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Random item selected"));
                    player.func_145747_a((ITextComponent)new TextComponentString("Selecting number of enchants to give item"));
                    ItemOfDestinyReward.this.changeEnchantAmount(item, player);
                } else {
                    item.func_92058_a(new ItemStack(ItemOfDestinyReward.this.randomItem(), 1));
                    ItemOfDestinyReward.this.changeItem(item, iteration + 1, player);
                }
            }
        };
        Scheduler.scheduleTask(task);
    }

    private void changeEnchantAmount(final EntityItem item, final EntityPlayer player) {
        Task task = new Task("Item_Of_Destiny_Reward", 50){

            @Override
            public void callback() {
                int i = ItemOfDestinyReward.this.rand.nextInt(9);
                int amount = i < 5 ? 1 : (i < 8 ? 2 : 3);
                player.func_145747_a((ITextComponent)new TextComponentString(amount + " random enchants will be added!"));
                player.func_145747_a((ITextComponent)new TextComponentString("Selecting random enchant to give to the item"));
                ItemOfDestinyReward.this.changeEnchants(item, amount, 0, player);
            }
        };
        Scheduler.scheduleTask(task);
    }

    private void changeEnchants(final EntityItem item, final int enchants, final int iteration, final EntityPlayer player) {
        Task task = new Task("Item_Of_Destiny_Reward", 50){

            @Override
            public void callback() {
                if (iteration < enchants) {
                    Enchantment ench = ItemOfDestinyReward.this.randomEnchantment();
                    int level = ench.func_77319_d() + ItemOfDestinyReward.this.rand.nextInt(ench.func_77325_b());
                    item.func_92059_d().func_77966_a(ench, level);
                    player.func_145747_a((ITextComponent)new TextComponentString(ench.func_77316_c(level) + " Has been added to the item!"));
                    ItemOfDestinyReward.this.changeEnchants(item, enchants, iteration + 1, player);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Your item of destiny is complete! Enjoy!"));
                    item.func_174867_a(0);
                }
            }
        };
        Scheduler.scheduleTask(task);
    }

    public Item randomItem() {
        Item item = Item.func_150899_d((int)(256 + this.rand.nextInt(166)));
        while (item == null) {
            item = Item.func_150899_d((int)(256 + this.rand.nextInt(166)));
        }
        return item;
    }

    public Enchantment randomEnchantment() {
        Enchantment ench = Enchantment.func_185262_c((int)this.rand.nextInt(Enchantment.field_185264_b.func_148742_b().size()));
        while (ench == null) {
            ench = Enchantment.func_185262_c((int)this.rand.nextInt(Enchantment.field_185264_b.func_148742_b().size()));
        }
        return ench;
    }

    @Override
    public int getChanceValue() {
        return 40;
    }

    @Override
    public String getName() {
        return "chancecubes:Item_Of_Destiny";
    }
}

