/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OffsetTileEntity
extends OffsetBlock {
    private NBTTagCompound teNBT;

    public OffsetTileEntity(int x, int y, int z, Block block, NBTTagCompound te, boolean falling) {
        this(x, y, z, block, te, falling, 0);
    }

    public OffsetTileEntity(int x, int y, int z, Block block, NBTTagCompound te, boolean falling, int delay) {
        super(x, y, z, block, falling, delay);
        this.teNBT = te;
    }

    @Override
    public void spawnInWorld(final World world, final int x, final int y, final int z) {
        if (!this.falling) {
            if (this.delay != 0) {
                Task task = new Task("Delayed_Block_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                    @Override
                    public void callback() {
                        OffsetTileEntity.this.placeInWorld(world, x, y, z, true);
                    }
                };
                Scheduler.scheduleTask(task);
            } else {
                this.placeInWorld(world, x, y, z, true);
            }
        } else if (this.delay != 0) {
            Task task = new Task("Falling_TileEntity_At_(" + this.xOff + "," + this.yOff + "," + this.zOff + ")", this.delay){

                @Override
                public void callback() {
                    OffsetTileEntity.this.spawnFallingBlock(world, x, y, z);
                }
            };
            Scheduler.scheduleTask(task);
        } else {
            this.spawnFallingBlock(world, x, y, z);
        }
    }

    @Override
    public void placeInWorld(World world, int x, int y, int z, boolean offset) {
        super.placeInWorld(world, x, y, z, offset);
        if (offset) {
            world.func_175690_a(new BlockPos(x + this.xOff, y + this.yOff, z + this.zOff), TileEntity.func_190200_a((World)world, (NBTTagCompound)this.teNBT));
        } else {
            world.func_175690_a(new BlockPos(x, y, z), TileEntity.func_190200_a((World)world, (NBTTagCompound)this.teNBT));
        }
    }
}

