/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.type;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.type.BaseRewardType;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityRewardType
extends BaseRewardType<EntityPart> {
    public EntityRewardType(EntityPart ... entities) {
        super(entities);
    }

    @Override
    public void trigger(final EntityPart part, final World world, final int x, final int y, final int z, final EntityPlayer player) {
        if (part.getDelay() != 0) {
            Task task = new Task("Entity Reward Delay", part.getDelay()){

                @Override
                public void callback() {
                    EntityRewardType.this.spawnEntity(part, world, x, y, z, player);
                }
            };
            Scheduler.scheduleTask(task);
        } else {
            this.spawnEntity(part, world, x, y, z, player);
        }
    }

    public void spawnEntity(EntityPart part, World world, int x, int y, int z, EntityPlayer player) {
        if (part.shouldRemovedBlocks()) {
            for (int yy = 0; yy < 4; ++yy) {
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        world.func_175698_g(new BlockPos(x + xx, y + yy, z + zz));
                    }
                }
            }
        }
        Entity newEnt = EntityList.func_75615_a((NBTTagCompound)part.getNBT(), (World)world);
        newEnt.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
        world.func_72838_d(newEnt);
    }

    public static NBTTagCompound getBasicNBTForEntity(String entity) {
        String json = "{id:" + entity + "}";
        NBTTagCompound nbt = null;
        try {
            nbt = JsonToNBT.func_180713_a((String)json);
        }
        catch (NBTException e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to create a simple NBTTagCompound from " + entity);
            return null;
        }
        return nbt;
    }
}

