/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.type;

import chanceCubes.CCubesCore;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.type.BaseRewardType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class SchematicRewardType
extends BaseRewardType<OffsetBlock> {
    private String schemName;
    private CustomRewardsLoader.Schematic schem;
    private int delay;
    private boolean falling;
    private boolean relativeToPlayer;

    public SchematicRewardType(String schemName, int delay, boolean falling, boolean rtp) {
        super(new OffsetBlock[0]);
        this.schemName = schemName;
        try {
            this.schem = CustomRewardsLoader.instance.parseSchematic(schemName, true);
        }
        catch (IOException e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to load a hardcoded schematic called " + this.schemName + ". It seems to be dead :(");
            return;
        }
        this.delay = delay;
        this.falling = falling;
        this.relativeToPlayer = rtp;
        List<OffsetBlock> blocks = this.loadSchematicReward();
        if (blocks == null) {
            return;
        }
        this.rewards = blocks.toArray(new OffsetBlock[blocks.size()]);
    }

    @Override
    protected void trigger(OffsetBlock block, World world, int x, int y, int z, EntityPlayer player) {
        if (this.rewards == null) {
            return;
        }
        if (block.isRelativeToPlayer()) {
            block.spawnInWorld(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            block.spawnInWorld(world, x, y, z);
        }
    }

    public List<OffsetBlock> loadSchematicReward() {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        if (this.schem == null) {
            CCubesCore.logger.log(Level.ERROR, "Failed to load a hardcoded schematic called " + this.schemName + ". It seems to be dead :(");
            return null;
        }
        int i = 0;
        short halfLength = (short)(this.schem.length / 2);
        short halfWidth = (short)(this.schem.width / 2);
        for (int yy = 0; yy < this.schem.height; ++yy) {
            for (int zz = 0; zz < this.schem.length; ++zz) {
                for (int xx = 0; xx < this.schem.width; ++xx) {
                    int j = this.schem.blocks[i];
                    if (j < 0) {
                        j = 128 + (128 + j);
                    }
                    Block b = Block.func_149729_e((int)j);
                    if (this.schem.tileentities != null) {
                        for (int i1 = 0; i1 < this.schem.tileentities.func_74745_c(); ++i1) {
                            TileEntity tileentity;
                            NBTTagCompound nbttagcompound4 = this.schem.tileentities.func_150305_b(i1);
                            if (nbttagcompound4.func_74762_e("x") != xx || nbttagcompound4.func_74762_e("y") != yy || nbttagcompound4.func_74762_e("z") != zz || (tileentity = TileEntity.func_190200_a(null, (NBTTagCompound)nbttagcompound4)) == null) continue;
                            OffsetTileEntity block = new OffsetTileEntity(tileentity.func_174877_v().func_177958_n(), tileentity.func_174877_v().func_177956_o(), tileentity.func_174877_v().func_177952_p(), b, nbttagcompound4, this.falling);
                            block.setRelativeToPlayer(this.relativeToPlayer);
                            block.setDealy(i * this.delay);
                            block.setData(this.schem.data[i]);
                            blocks.add(block);
                        }
                    }
                    if (b != Blocks.field_150350_a) {
                        OffsetBlock block = new OffsetBlock(halfWidth - xx, yy, halfLength - zz, b, this.falling);
                        block.setRelativeToPlayer(this.relativeToPlayer);
                        block.setDealy(i * this.delay);
                        block.setData(this.schem.data[i]);
                        blocks.add(block);
                    }
                    ++i;
                }
            }
        }
        return blocks;
    }
}

