/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.ParticlePart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class RewardsUtil {
    public static OffsetBlock[] fillArea(int xSize, int ySize, int zSize, Block block, int xOff, int yOff, int zOff, boolean falling, int delay, boolean causesUpdate, boolean relativeToPlayer) {
        ArrayList<OffsetBlock> toReturn = new ArrayList<OffsetBlock>();
        for (int y = 0; y < ySize; ++y) {
            for (int z = 0; z < zSize; ++z) {
                for (int x = 0; x < xSize; ++x) {
                    toReturn.add(new OffsetBlock(x + xOff, y + yOff, z + zOff, block, falling, delay).setCausesBlockUpdate(causesUpdate).setRelativeToPlayer(relativeToPlayer));
                }
            }
        }
        return toReturn.toArray(new OffsetBlock[toReturn.size()]);
    }

    public static OffsetBlock[] addBlocksLists(OffsetBlock[] ... lists) {
        int size = 0;
        for (OffsetBlock[] list : lists) {
            size += list.length;
        }
        OffsetBlock[] toReturn = new OffsetBlock[size];
        int i = 0;
        OffsetBlock[][] offsetBlockArray = lists;
        int n = offsetBlockArray.length;
        for (int j = 0; j < n; ++j) {
            OffsetBlock[] list;
            OffsetBlock[] offsetBlockArray2 = list = offsetBlockArray[j];
            int n2 = offsetBlockArray2.length;
            for (int k = 0; k < n2; ++k) {
                OffsetBlock osb;
                toReturn[i] = osb = offsetBlockArray2[k];
                ++i;
            }
        }
        return toReturn;
    }

    public static EntityPart[] spawnXEntities(NBTTagCompound entityNbt, int amount) {
        EntityPart[] toReturn = new EntityPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new EntityPart(entityNbt);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static ParticlePart[] spawnXParticles(int particle, int amount) {
        ParticlePart[] toReturn = new ParticlePart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new ParticlePart(particle);
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(World world, BlockPos pos, int distance, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist <= (double)distance)) continue;
            entityplayer.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static void sendMessageToAllPlayers(World world, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            entityplayer.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static ItemStack getItemStack(String mod, String itemName, int size) {
        return RewardsUtil.getItemStack(mod, itemName, size, 0);
    }

    public static ItemStack getItemStack(String mod, String itemName, int size, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
        return item == null ? null : new ItemStack(item, size, meta);
    }

    public static Block getBlock(String mod, String blockName) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos) {
        return RewardsUtil.placeBlock(b, world, pos, 3);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos, int update) {
        if (!RewardsUtil.isBlockUnbreakable(world, pos)) {
            world.func_180501_a(pos, b, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f;
    }
}

