/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.craftingtweaks.CommonProxy;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.GuiTweakButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.blay09.mods.craftingtweaks.net.MessageBalance;
import net.blay09.mods.craftingtweaks.net.MessageClear;
import net.blay09.mods.craftingtweaks.net.MessageCompress;
import net.blay09.mods.craftingtweaks.net.MessageRotate;
import net.blay09.mods.craftingtweaks.net.MessageTransferStack;
import net.blay09.mods.craftingtweaks.net.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    private final ClientProvider clientProvider = new ClientProvider();
    private final KeyBinding keyRotate = new KeyBinding("key.craftingtweaks.rotate", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 19, "key.categories.craftingtweaks");
    private final KeyBinding keyBalance = new KeyBinding("key.craftingtweaks.balance", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 48, "key.categories.craftingtweaks");
    private final KeyBinding keyClear = new KeyBinding("key.craftingtweaks.clear", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 46, "key.categories.craftingtweaks");
    private final KeyBinding keyToggleButtons = new KeyBinding("key.craftingtweaks.toggleButtons", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 0, "key.categories.craftingtweaks");
    private final KeyBinding keyCompressOne = new KeyBinding("key.craftingtweaks.compressOne", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, 37, "key.categories.craftingtweaks");
    private final KeyBinding keyCompressStack = new KeyBinding("key.craftingtweaks.compressStack", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 37, "key.categories.craftingtweaks");
    private final KeyBinding keyCompressAll = new KeyBinding("key.craftingtweaks.compressAll", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, 37, "key.categories.craftingtweaks");
    private final KeyBinding keyDecompressOne = new KeyBinding("key.craftingtweaks.decompressOne", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 0, "key.categories.craftingtweaks");
    private final KeyBinding keyDecompressStack = new KeyBinding("key.craftingtweaks.decompressStack", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 0, "key.categories.craftingtweaks");
    private final KeyBinding keyDecompressAll = new KeyBinding("key.craftingtweaks.decompressAll", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 0, "key.categories.craftingtweaks");
    private KeyBinding keyTransferStack;
    private boolean ignoreMouseUp;
    private static final List<String> tooltipList = Lists.newArrayList();

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotate);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBalance);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyClear);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyToggleButtons);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyCompressOne);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyCompressStack);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyCompressAll);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyDecompressOne);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyDecompressStack);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyDecompressAll);
        this.keyTransferStack = Minecraft.func_71410_x().field_71474_y.field_74351_w;
    }

    @Override
    public void addScheduledTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        Container container;
        EntityPlayerSP entityPlayer;
        if (Keyboard.getEventKeyState() && (entityPlayer = FMLClientHandler.instance().getClientPlayerEntity()) != null && (container = entityPlayer.field_71070_bA) != null) {
            GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
            TweakProvider<Container> provider = CraftingTweaks.instance.getProvider(container);
            CompressType compressType = this.getCompressType(Keyboard.getEventKey());
            if (provider != null) {
                boolean isShiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                CraftingTweaks.ModSupportState config = CraftingTweaks.instance.getModSupportState(provider.getModId());
                if (config == CraftingTweaks.ModSupportState.ENABLED || config == CraftingTweaks.ModSupportState.HOTKEYS_ONLY) {
                    if (this.keyRotate.func_151463_i() > 0 && Keyboard.getEventKey() == this.keyRotate.func_151463_i()) {
                        if (CraftingTweaks.isServerSideInstalled) {
                            NetworkHandler.instance.sendToServer((IMessage)new MessageRotate(0, isShiftDown));
                        } else {
                            this.clientProvider.rotateGrid(provider, (EntityPlayer)entityPlayer, container, 0, isShiftDown);
                        }
                    } else if (this.keyClear.func_151463_i() > 0 && Keyboard.getEventKey() == this.keyClear.func_151463_i()) {
                        if (CraftingTweaks.isServerSideInstalled) {
                            NetworkHandler.instance.sendToServer((IMessage)new MessageClear(0, isShiftDown));
                        } else {
                            this.clientProvider.clearGrid(provider, (EntityPlayer)entityPlayer, container, 0, isShiftDown);
                        }
                    } else if (this.keyBalance.func_151463_i() > 0 && Keyboard.getEventKey() == this.keyBalance.func_151463_i()) {
                        if (CraftingTweaks.isServerSideInstalled) {
                            NetworkHandler.instance.sendToServer((IMessage)new MessageBalance(0, isShiftDown));
                        } else if (isShiftDown) {
                            this.clientProvider.spreadGrid(provider, (EntityPlayer)entityPlayer, container, 0);
                        } else {
                            this.clientProvider.balanceGrid(provider, (EntityPlayer)entityPlayer, container, 0);
                        }
                    }
                }
                if (guiScreen instanceof GuiContainer) {
                    GuiContainer guiContainer = (GuiContainer)guiScreen;
                    if (compressType != null) {
                        Slot mouseSlot = guiContainer.getSlotUnderMouse();
                        if (mouseSlot != null) {
                            if (CraftingTweaks.isServerSideInstalled) {
                                NetworkHandler.instance.sendToServer((IMessage)new MessageCompress(mouseSlot.field_75222_d, compressType));
                            } else {
                                this.clientProvider.compress(provider, (EntityPlayer)entityPlayer, container, mouseSlot, compressType);
                            }
                        }
                    } else if (this.keyToggleButtons.func_151463_i() > 0 && Keyboard.getEventKey() == this.keyToggleButtons.func_151463_i()) {
                        boolean bl = CraftingTweaks.hideButtons = !CraftingTweaks.hideButtons;
                        if (CraftingTweaks.hideButtons) {
                            Iterator it = guiScreen.field_146292_n.iterator();
                            while (it.hasNext()) {
                                if (!(it.next() instanceof GuiTweakButton)) continue;
                                it.remove();
                            }
                        } else {
                            this.initGui(guiContainer);
                        }
                        CraftingTweaks.saveConfig();
                    }
                }
            } else if (CraftingTweaks.isServerSideInstalled && guiScreen instanceof GuiContainer) {
                Slot mouseSlot;
                GuiContainer guiContainer = (GuiContainer)guiScreen;
                if (compressType != null && (mouseSlot = guiContainer.getSlotUnderMouse()) != null) {
                    NetworkHandler.instance.sendToServer((IMessage)new MessageCompress(mouseSlot.field_75222_d, compressType));
                }
            }
        }
    }

    private CompressType getCompressType(int eventKey) {
        if (this.isActiveAndMatches(this.keyCompressOne, eventKey)) {
            return CompressType.COMPRESS_ONE;
        }
        if (this.isActiveAndMatches(this.keyCompressStack, eventKey)) {
            return CompressType.COMPRESS_STACK;
        }
        if (this.isActiveAndMatches(this.keyCompressAll, eventKey)) {
            return CompressType.COMPRESS_ALL;
        }
        if (this.isActiveAndMatches(this.keyDecompressOne, eventKey)) {
            return CompressType.DECOMPRESS_ONE;
        }
        if (this.isActiveAndMatches(this.keyDecompressStack, eventKey)) {
            return CompressType.DECOMPRESS_STACK;
        }
        if (this.isActiveAndMatches(this.keyDecompressAll, eventKey)) {
            return CompressType.DECOMPRESS_ALL;
        }
        return null;
    }

    private boolean isActiveAndMatches(KeyBinding keyBinding, int eventKey) {
        if (keyBinding.getKeyModifier() == KeyModifier.NONE && (KeyModifier.SHIFT.isActive() || KeyModifier.CONTROL.isActive() || KeyModifier.ALT.isActive())) {
            return false;
        }
        return keyBinding.isActiveAndMatches(eventKey);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiMouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Mouse.getEventButtonState()) {
            Container container;
            EntityPlayerSP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entityPlayer != null && (container = entityPlayer.field_71070_bA) != null) {
                Slot mouseSlot = event.getGui() instanceof GuiContainer ? ((GuiContainer)event.getGui()).getSlotUnderMouse() : null;
                TweakProvider<Container> provider = CraftingTweaks.instance.getProvider(container);
                if (provider != null && provider.isValidContainer(container)) {
                    if (this.keyTransferStack.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyTransferStack.func_151463_i())) {
                        if (mouseSlot != null && mouseSlot.func_75216_d()) {
                            ArrayList transferSlots = Lists.newArrayList();
                            transferSlots.add(mouseSlot);
                            if (Keyboard.isKeyDown((int)42)) {
                                ItemStack mouseSlotStack = mouseSlot.func_75211_c();
                                for (Slot slot : container.field_75151_b) {
                                    ItemStack slotStack;
                                    if (!slot.func_75216_d() || mouseSlot == slot || !(slotStack = slot.func_75211_c()).func_77969_a(mouseSlotStack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseSlotStack)) continue;
                                    transferSlots.add(slot);
                                }
                            }
                            if (CraftingTweaks.isServerSideInstalled) {
                                for (Slot slot : transferSlots) {
                                    NetworkHandler.instance.sendToServer((IMessage)new MessageTransferStack(0, slot.field_75222_d));
                                }
                            } else {
                                for (Slot slot : transferSlots) {
                                    this.clientProvider.transferIntoGrid(provider, (EntityPlayer)entityPlayer, container, 0, slot);
                                }
                                this.ignoreMouseUp = true;
                            }
                            event.setCanceled(true);
                        }
                    } else if (CraftingTweaks.rightClickCraftsStack && Mouse.getEventButton() == 1 && mouseSlot instanceof SlotCrafting) {
                        PlayerControllerMP playerController = Minecraft.func_71410_x().field_71442_b;
                        if (playerController == null) {
                            return;
                        }
                        ItemStack mouseStack = entityPlayer.field_71071_by.func_70445_o();
                        for (int maxTries = 64; maxTries > 0 && mouseSlot.func_75216_d() && (mouseStack == null || mouseStack.field_77994_a < mouseStack.func_77976_d()); --maxTries) {
                            playerController.func_187098_a(container.field_75152_c, mouseSlot.field_75222_d, 0, ClickType.PICKUP, (EntityPlayer)entityPlayer);
                            mouseStack = entityPlayer.field_71071_by.func_70445_o();
                        }
                        event.setCanceled(true);
                        this.ignoreMouseUp = true;
                    }
                }
            }
        } else if (this.ignoreMouseUp) {
            event.setCanceled(true);
            this.ignoreMouseUp = false;
        }
    }

    private void initGui(GuiContainer guiContainer) {
        CraftingTweaks.ModSupportState config;
        TweakProvider<Container> provider = CraftingTweaks.instance.getProvider(guiContainer.field_147002_h);
        if (provider != null && ((config = CraftingTweaks.instance.getModSupportState(provider.getModId())) == CraftingTweaks.ModSupportState.ENABLED || config == CraftingTweaks.ModSupportState.BUTTONS_ONLY) && provider.isValidContainer(guiContainer.field_147002_h)) {
            provider.initGui(guiContainer, guiContainer.field_146292_n);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!CraftingTweaks.hideButtons && event.getGui() instanceof GuiContainer) {
            this.initGui((GuiContainer)event.getGui());
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() == null) {
            return;
        }
        if (!CraftingTweaks.hideButtonTooltips) {
            tooltipList.clear();
            for (GuiButton button : event.getGui().field_146292_n) {
                if (!(button instanceof ITooltipProvider) || !button.func_146115_a()) continue;
                ((ITooltipProvider)button).addInformation(tooltipList);
                break;
            }
            if (!tooltipList.isEmpty()) {
                event.getGui().func_146283_a(tooltipList, event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiTweakButton) {
            event.getButton().func_146113_a(Minecraft.func_71410_x().func_147118_V());
            EntityPlayerSP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            Container container = entityPlayer.field_71070_bA;
            TweakProvider<Container> provider = CraftingTweaks.instance.getProvider(container);
            boolean isShiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            switch (((GuiTweakButton)event.getButton()).getTweakOption()) {
                case Rotate: {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageRotate(((GuiTweakButton)event.getButton()).getTweakId(), isShiftDown));
                    } else {
                        this.clientProvider.rotateGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.getButton()).getTweakId(), isShiftDown);
                    }
                    event.setCanceled(true);
                    break;
                }
                case Balance: {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageBalance(((GuiTweakButton)event.getButton()).getTweakId(), isShiftDown));
                    } else if (isShiftDown) {
                        this.clientProvider.spreadGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.getButton()).getTweakId());
                    } else {
                        this.clientProvider.balanceGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.getButton()).getTweakId());
                    }
                    event.setCanceled(true);
                    break;
                }
                case Clear: {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageClear(((GuiTweakButton)event.getButton()).getTweakId(), isShiftDown));
                    } else {
                        this.clientProvider.clearGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.getButton()).getTweakId(), isShiftDown);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }
}

