/*
 * Decompiled with CFR 0.152.
 */
package mrcomputerghost.xprings;

import mrcomputerghost.xprings.items.ItemXPRing;
import mrcomputerghost.xprings.proxy.CommonProxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@Mod(modid="xprings", name="Experience Rings", version="1.2.0", dependencies="required-after:Baubles", acceptedMinecraftVersions="[1.9.4]")
public class XPRings {
    @Mod.Instance
    public static XPRings instance;
    @SidedProxy(serverSide="mrcomputerghost.xprings.proxy.CommonProxy", clientSide="mrcomputerghost.xprings.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static Item lesserXPRing;
    public static Item xpRing;
    public static Item greaterXPRing;
    private static int dungeonSpawnChance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        dungeonSpawnChance = config.getInt("dungeonSpawnChance", "general", 2, 0, 100, "Chance for Lesser Rings O' Experience to spawn in Dungeon Chests. Set to <1 to disable.");
        int bottlesCrafted = config.getInt("bottlesCrafted", "general", 2, 0, 64, "Number of Bottles O' Experience to craft from the Lesser Ring O' Experience. Set to <1 to disable.");
        int lesserRingRadius = config.getInt("lesserRingRadius", "general", 2, 1, 64, "Radius of the Lesser Ring O' Experience.");
        int genericRingRadius = config.getInt("genericRingRadius", "general", 5, 1, 64, "Radius of the Lesser Ring O' Experience.");
        int greaterRingRadius = config.getInt("greaterRingRadius", "general", 12, 1, 64, "Radius of the Lesser Ring O' Experience.");
        boolean allowLesserRing = config.getBoolean("allowLesserRing", "general", true, "Allow the existence of the Lesser Ring O' Experience");
        boolean allowGenericRing = config.getBoolean("allowLesserRing", "general", true, "Allow the existence of the Ring O' Experience");
        boolean allowGreaterRing = config.getBoolean("allowLesserRing", "general", true, "Allow the existence of the Greater Ring O' Experience");
        boolean allowXPCrafting = config.getBoolean("allowXPCrafting", "general", true, "Allow crafting of Bottles O' Experience from the Lesser Ring O' Experience");
        boolean allowLesserCrafting = config.getBoolean("allowLesserCrafting", "general", false, "Allow crafting of the Lesser Ring O' Experience.");
        boolean allowGenericCrafting = config.getBoolean("allowGenericCrafting", "general", true, "Allow crafting of the Ring O' Experience.");
        boolean allowGreaterCrafting = config.getBoolean("allowGreaterCrafting", "general", true, "Allow crafting of the Greater Ring O' Experience");
        config.save();
        if (allowLesserRing) {
            lesserXPRing = (Item)GameRegistry.register((IForgeRegistryEntry)new ItemXPRing(2, lesserRingRadius));
        }
        if (allowGenericRing) {
            xpRing = (Item)GameRegistry.register((IForgeRegistryEntry)new ItemXPRing(5, genericRingRadius));
        }
        if (allowGreaterRing) {
            greaterXPRing = (Item)GameRegistry.register((IForgeRegistryEntry)new ItemXPRing(12, greaterRingRadius));
        }
        if (allowLesserCrafting && allowLesserRing) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(lesserXPRing, 1, 0), (Object[])new Object[]{"BNB", "NGN", "BNB", Character.valueOf('B'), Items.field_151062_by, Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('G'), Items.field_151069_bo});
        }
        if (allowGenericCrafting && allowGenericRing && allowLesserRing) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(xpRing, 1, 0), (Object[])new Object[]{"IBI", "BRB", "IBI", Character.valueOf('R'), Items.field_151042_j, Character.valueOf('B'), Items.field_151062_by, Character.valueOf('I'), lesserXPRing});
        }
        if (allowGreaterCrafting && allowGreaterRing && allowGenericRing) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(greaterXPRing, 1, 0), (Object[])new Object[]{"BRB", "RIR", "BRB", Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('B'), Items.field_151062_by, Character.valueOf('R'), xpRing});
        }
        if (bottlesCrafted > 0 && allowXPCrafting && allowLesserRing) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151062_by, bottlesCrafted, 0), (Object[])new Object[]{lesserXPRing});
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (dungeonSpawnChance > 0 && event.getName().equals((Object)LootTableList.field_186422_d)) {
            event.getTable().getPool("pool3").addEntry((LootEntry)new LootEntryItem(lesserXPRing, dungeonSpawnChance, 0, null, null, "loottable:lesserXPRing"));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }
}

