/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tesla.lib;

import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PowerBar {
    public static final int WIDTH = 14;
    public static final int HEIGHT = 50;
    private static final ResourceLocation TEXTURE_SHEET = new ResourceLocation("tesla", "textures/gui/elements.png");
    private final int x;
    private final int y;
    private final GuiScreen screen;
    private final BackgroundType background;

    public PowerBar(GuiScreen screen, int x, int y, BackgroundType type) {
        this.background = type;
        this.screen = screen;
        this.x = x;
        this.y = y;
    }

    public void draw(ITeslaHolder holder) {
        this.draw(holder.getStoredPower(), holder.getCapacity());
    }

    public void draw(long power, long capacity) {
        this.screen.field_146297_k.func_110434_K().func_110577_a(TEXTURE_SHEET);
        if (this.background == BackgroundType.LIGHT) {
            this.screen.func_73729_b(this.x, this.y, 3, 1, 14, 50);
        } else if (this.background == BackgroundType.DARK) {
            this.screen.func_73729_b(this.x, this.y, 3, 53, 14, 50);
        }
        long powerOffset = power * 51L / capacity;
        this.screen.func_73729_b(this.x + 1, (int)((long)(this.y + 50) - powerOffset), 18, (int)(51L - powerOffset), 14, (int)(powerOffset + 2L));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static enum BackgroundType {
        NONE,
        LIGHT,
        DARK;

    }
}

