/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.chiselsbytes.client;

import com.typesafe.config.ConfigException;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.API;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.ItemType;
import mods.belgabor.chiselsbytes.ChiselsBytes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;

public class KeybindHandler {
    public static KeyBinding keybind;

    public static void init() {
        keybind = new KeyBinding("chiselsbytes.keybind", 201, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)keybind);
    }

    private static void findRegions(String[][][] textures, String[][][] tints, List<String> regions, int xDir, int yDir, int zDir, boolean state) {
        int y;
        boolean[][][] handled = new boolean[16][16][16];
        int xMin = xDir > 0 ? 0 : 15;
        int yMin = yDir > 0 ? 0 : 15;
        int zMin = zDir > 0 ? 0 : 15;
        for (int x = 0; x < 16; ++x) {
            for (y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (textures[x][y][z] != null) continue;
                    handled[x][y][z] = true;
                }
            }
        }
        for (int z = zMin; z >= 0 && z < 16; z += zDir) {
            for (y = yMin; y >= 0 && y < 16; y += yDir) {
                for (int x = xMin; x >= 0 && x < 16; x += xDir) {
                    if (handled[x][y][z]) continue;
                    String current_texture = textures[x][y][z];
                    String current_tint = tints[x][y][z];
                    int xEnd = x;
                    int yEnd = y;
                    int zEnd = z;
                    for (int xr = x + xDir; xr >= 0 && xr < 16 && !handled[xr][y][z] && textures[xr][y][z].equals(current_texture) && tints[xr][y][z].equals(current_tint); xr += xDir) {
                        xEnd += xDir;
                    }
                    int xFrom = Math.min(x, xEnd);
                    int xTo = Math.max(xEnd, x);
                    for (int yr = y + yDir; yr >= 0 && yr < 16; yr += yDir) {
                        boolean ok = true;
                        for (int xr = xFrom; xr <= xTo; ++xr) {
                            if (!handled[xr][yr][z] && textures[xr][yr][z].equals(current_texture) && tints[xr][yr][z].equals(current_tint)) continue;
                            ok = false;
                            break;
                        }
                        if (!ok) break;
                        yEnd += yDir;
                    }
                    int yFrom = Math.min(y, yEnd);
                    int yTo = Math.max(yEnd, y);
                    for (int zr = z + zDir; zr >= 0 && zr < 16; zr += zDir) {
                        boolean ok = true;
                        for (int yr = yFrom; yr <= yTo; ++yr) {
                            for (int xr = xFrom; xr <= xTo; ++xr) {
                                if (!handled[xr][yr][zr] && textures[xr][yr][zr].equals(current_texture) && tints[xr][yr][zr].equals(current_tint)) continue;
                                ok = false;
                                break;
                            }
                            if (!ok) break;
                        }
                        if (!ok) break;
                        zEnd += zDir;
                    }
                    int zFrom = Math.min(z, zEnd);
                    int zTo = Math.max(zEnd, z);
                    String res = String.format("    {%02d, %02d, %02d, %02d, %02d, %02d, texture = \"%s\"", xFrom, yFrom, 16 - (zTo + 1), xTo + 1, yTo + 1, 16 - zFrom, current_texture);
                    if (!current_tint.equals("FFFFFF")) {
                        res = res + String.format(", tint = 0x%s", current_tint);
                    }
                    if (state) {
                        res = res + ", state = true";
                    }
                    res = res + "}";
                    regions.add(res);
                    for (int zr = zFrom; zr <= zTo; ++zr) {
                        for (int yr = yFrom; yr <= yTo; ++yr) {
                            for (int xr = xFrom; xr <= xTo; ++xr) {
                                handled[xr][yr][zr] = true;
                            }
                        }
                    }
                }
            }
        }
    }

    private static List<String> findBest(EntityPlayer player, String[][][] textures, String[][][] tints, boolean state) {
        ArrayList<String> results = new ArrayList<String>();
        int i = 1;
        for (int x = -1; x <= 1; x += 2) {
            for (int y = -1; y <= 1; y += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.variant", new Object[]{i, x, y, z}));
                    ArrayList<String> tResults = new ArrayList<String>();
                    KeybindHandler.findRegions(textures, tints, tResults, x, y, z, state);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.shapes", new Object[]{tResults.size()}));
                    if (results.size() == 0 || results.size() > tResults.size()) {
                        results = tResults;
                    }
                    ++i;
                }
            }
        }
        return results;
    }

    private static String colorToString(int color) {
        return String.format("%06X", color & 0xFFFFFF);
    }

    private static void examineBlock(IBitAccess bits, Minecraft mc, String[][][] textures, String[][][] tints, Features features, boolean sneaking) {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Block tBlock;
                    IBlockState state = bits.getBitAt(x, y, z).getState();
                    if (state == null) continue;
                    String texture = "error";
                    String tint = "FFFFFF";
                    IBakedModel model = mc.func_175602_ab().func_175023_a().func_178125_b(state);
                    if (model != null && model.func_177554_e() != null && model.func_177554_e().func_94215_i() != null) {
                        texture = model.func_177554_e().func_94215_i();
                    }
                    if ((tBlock = state.func_177230_c()) != null) {
                        Fluid fluid = null;
                        if (state.func_185906_d() > features.lightLevel) {
                            features.lightLevel = state.func_185906_d();
                        }
                        if (tBlock instanceof IFluidBlock) {
                            fluid = ((IFluidBlock)tBlock).getFluid();
                        } else if (tBlock instanceof BlockStaticLiquid) {
                            if (tBlock.func_149739_a().equals("tile.water")) {
                                fluid = FluidRegistry.getFluid((String)"water");
                            } else if (tBlock.func_149739_a().equals("tile.lava")) {
                                fluid = FluidRegistry.getFluid((String)"lava");
                            }
                        }
                        if (fluid != null) {
                            features.hasFluids = true;
                            texture = sneaking ? fluid.getFlowing().toString() : fluid.getStill().toString();
                            tint = KeybindHandler.colorToString(fluid.getColor());
                        }
                        if (tBlock.getClass().getCanonicalName().startsWith("mod.flatcoloredblocks.block.BlockFlatColored")) {
                            Class<?> c = tBlock.getClass();
                            Method m = null;
                            Class[] pTypes = new Class[]{IBlockState.class};
                            try {
                                m = c.getMethod("colorFromState", pTypes);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            if (m != null) {
                                Object[] params = new Object[]{state};
                                try {
                                    int col = (Integer)m.invoke((Object)tBlock, params);
                                    tint = KeybindHandler.colorToString(col);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                }
                                catch (ClassCastException classCastException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    textures[x][y][z] = texture;
                    tints[x][y][z] = tint;
                }
            }
        }
    }

    private static boolean isCompatibleItem(ItemStack stack) {
        if (ChiselsBytes.cnb_api == null || stack == null) {
            return false;
        }
        ItemType type = ChiselsBytes.cnb_api.getItemType(stack);
        return type != null && type != ItemType.NEGATIVE_DESIGN && type.isBitAccess;
    }

    public static void keyDown() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack stack = player.func_184614_ca();
        Features features = new Features();
        if (KeybindHandler.isCompatibleItem(stack)) {
            IBitAccess bits = ChiselsBytes.cnb_api.createBitItem(stack);
            if (bits != null) {
                int slot;
                String[][][] textures = new String[16][16][16];
                String[][][] tints = new String[16][16][16];
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.start", new Object[0]));
                String result = "{\n  label=\"Converted Chisels & Bits block\",\n";
                KeybindHandler.examineBlock(bits, mc, textures, tints, features, player.func_70093_af());
                List<String> results = KeybindHandler.findBest((EntityPlayer)player, textures, tints, false);
                List<String> results_active = null;
                int shape_count = results.size();
                int shape_count_act = 0;
                ItemStack stack_next = player.func_184592_cb();
                if (!KeybindHandler.isCompatibleItem(stack_next) && (slot = player.field_71071_by.field_70461_c) != 9) {
                    stack_next = player.field_71071_by.func_70301_a(slot + 1);
                }
                if (KeybindHandler.isCompatibleItem(stack_next) && (bits = ChiselsBytes.cnb_api.createBitItem(stack_next)) != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.startact", new Object[0]));
                    textures = new String[16][16][16];
                    tints = new String[16][16][16];
                    KeybindHandler.examineBlock(bits, mc, textures, tints, features, player.func_70093_af());
                    results_active = KeybindHandler.findBest((EntityPlayer)player, textures, tints, true);
                    shape_count_act = results.size();
                }
                if (features.lightLevel > 0) {
                    result = result + String.format("  lightLevel = %d,\n", Math.min(8, features.lightLevel));
                    if (features.lightLevel > 8) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.warning.light", new Object[]{features.lightLevel}));
                    }
                }
                result = result + "  shapes = {\n";
                result = result + String.join((CharSequence)",\n", results);
                if (shape_count_act > 0) {
                    result = result + ",\n";
                    result = result + String.join((CharSequence)",\n", results_active);
                }
                result = result + "\n  }\n}\n";
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.optimal", new Object[]{shape_count}));
                if (shape_count_act > 0) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.optimalact", new Object[]{shape_count_act}));
                }
                if (features.hasFluids) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.fluid" + (player.func_70093_af() ? "sneak" : "nosneak"), new Object[0]));
                }
                if (Loader.isModLoaded((String)"OpenComputers")) {
                    int maxShapes = -1;
                    try {
                        maxShapes = API.config.getInt("printer.maxShapes");
                    }
                    catch (ConfigException configException) {
                        // empty catch block
                    }
                    if (maxShapes >= 0 && (shape_count > maxShapes || shape_count_act > maxShapes)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.warning.shapes", new Object[]{maxShapes}));
                    }
                }
                if (Desktop.isDesktopSupported()) {
                    StringSelection sel = new StringSelection(result);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(sel, null);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.info.clipsuccess", new Object[0]));
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.error.clipfail", new Object[0]));
                }
            }
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chiselsbytes.message.error.nocnb", new Object[0]));
        }
    }

    private static class Features {
        protected boolean hasFluids = false;
        protected int lightLevel = 0;

        private Features() {
        }
    }
}

