/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot;

public class IntegerRange {
    public int lhs;
    public int rhs;

    public static IntegerRange parse(String token) throws Exception {
        IntegerRange ret = new IntegerRange();
        ret.lhs = -99999999;
        ret.rhs = 99999999;
        if (token.equals("*")) {
            return ret;
        }
        String lhsStr = IntegerRange.getIntegerStringFrom(token, 0);
        if (!IntegerRange.validateIntegerLength(lhsStr)) {
            throw new Exception("Invalid range");
        }
        ret.lhs = Integer.parseInt(lhsStr);
        if (lhsStr.length() == token.length()) {
            ret.rhs = ret.lhs;
        } else {
            String rhsStr = IntegerRange.getIntegerStringFrom(token, lhsStr.length() + 1);
            if (!IntegerRange.validateIntegerLength(rhsStr)) {
                throw new Exception("Invalid range");
            }
            ret.rhs = Integer.parseInt(rhsStr);
            if (ret.lhs > ret.rhs) {
                int tmp = ret.lhs;
                ret.lhs = ret.rhs;
                ret.rhs = tmp;
            }
            if (lhsStr.length() + rhsStr.length() + 1 != token.length()) {
                throw new Exception("Invalid range");
            }
        }
        return ret;
    }

    public static String getIntegerStringFrom(String token, int start) {
        char c;
        StringBuilder ret = new StringBuilder();
        for (int i = start; i < token.length() && ((c = token.charAt(i)) >= '0' && c <= '9' || (c == '-' || c == '+') && i == start); ++i) {
            ret.append(c);
        }
        if (ret.toString().equals("-") || ret.toString().equals("+")) {
            return "";
        }
        return ret.toString();
    }

    public static boolean validateIntegerLength(String num) {
        int len = num.length();
        if (num.startsWith("-") || num.startsWith("+")) {
            --len;
        }
        return len >= 1 && len <= 8;
    }
}

