/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot;

import com.mmyzd.nmsot.IntegerRange;
import com.mmyzd.nmsot.rule.RuleBiome;
import com.mmyzd.nmsot.rule.RuleBiomeType;
import com.mmyzd.nmsot.rule.RuleMob;
import com.mmyzd.nmsot.rule.RuleMobType;
import com.mmyzd.nmsot.rule.RuleSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import org.apache.logging.log4j.LogManager;

public class SpawnListManager {
    private static ArrayList<SpawnEntry> entries = new ArrayList();

    public static void parse(LinkedList<Character> s) throws Exception {
        int weight = 100;
        int countMin = 4;
        int countMax = 4;
        EnumCreatureType type = EnumCreatureType.MONSTER;
        HashSet<Biome> biomes = new HashSet<Biome>();
        HashSet<Class<? extends Entity>> mobs = new HashSet<Class<? extends Entity>>();
        do {
            String token;
            if ((token = RuleSet.getToken(s)).equalsIgnoreCase("biome")) {
                RuleBiome ruleBiome = new RuleBiome(s);
                if (ruleBiome.index == -1) continue;
                biomes.add(Biome.func_150568_d((int)ruleBiome.index));
                continue;
            }
            if (token.equalsIgnoreCase("biometype")) {
                RuleBiomeType ruleBiomeType = new RuleBiomeType(s);
                for (Integer index : ruleBiomeType.biomeIDs) {
                    biomes.add(Biome.func_150568_d((int)index));
                }
            } else {
                if (token.equalsIgnoreCase("mob")) {
                    RuleMob ruleMob = new RuleMob(s);
                    if (ruleMob.entityClasses != null) {
                        mobs.addAll(ruleMob.entityClasses);
                    }
                    if (ruleMob.entityClass == null) continue;
                    mobs.add(ruleMob.entityClass);
                    continue;
                }
                if (token.equalsIgnoreCase("weight")) {
                    RuleSet.nextPart(s);
                    try {
                        weight = Integer.parseInt(RuleSet.getToken(s));
                    }
                    catch (Exception exception) {
                        throw new Exception("Invalid weight");
                    }
                } else {
                    if (token.equalsIgnoreCase("count")) {
                        RuleSet.nextPart(s);
                        IntegerRange integerRange = IntegerRange.parse(RuleSet.getToken(s));
                        countMin = integerRange.lhs;
                        countMax = integerRange.rhs;
                        continue;
                    }
                    if (token.equalsIgnoreCase("mobtype")) {
                        RuleMobType ruleMobType = new RuleMobType(s);
                        if (ruleMobType.type == null) continue;
                        type = ruleMobType.type;
                        continue;
                    }
                    throw new Exception("Invalid tag <" + token + ">");
                }
            }
        } while (RuleSet.getTokenEqualsIgnoreCase(s, ","));
        if (RuleSet.skipSpace(s) != '#') {
            throw new Exception("Syntax error");
        }
        for (Class clazz : mobs) {
            for (Biome biome : biomes) {
                boolean modified = false;
                List spawns = biome.func_76747_a(type);
                for (Biome.SpawnListEntry entry : spawns) {
                    if (entry.field_76300_b != clazz) continue;
                    SpawnEntry e = new SpawnEntry();
                    e.biome = biome;
                    e.mob = clazz;
                    e.type = type;
                    e.weight = entry.field_76292_a;
                    e.countMin = entry.field_76301_c;
                    e.countMax = entry.field_76299_d;
                    e.add = false;
                    entries.add(e);
                    e = new SpawnEntry();
                    e.biome = biome;
                    e.mob = clazz;
                    e.type = type;
                    e.weight = entry.field_76292_a = weight;
                    e.countMin = entry.field_76301_c = countMin;
                    e.countMax = entry.field_76299_d = countMax;
                    entries.add(e);
                    LogManager.getLogger((String)"nmsot").info("  modified spawn entry " + e.mob.getSimpleName() + ": " + weight + ", " + countMin + ", " + countMax + " at " + biome.func_185359_l());
                    modified = true;
                }
                if (modified) continue;
                SpawnEntry e = new SpawnEntry();
                e.biome = biome;
                e.mob = clazz;
                e.type = type;
                e.weight = weight;
                e.countMin = countMin;
                e.countMax = countMax;
                entries.add(e);
                spawns.add(new Biome.SpawnListEntry(clazz, weight, countMin, countMax));
                LogManager.getLogger((String)"nmsot").info("  added spawn entry " + e.mob.getSimpleName() + ": " + weight + ", " + countMin + ", " + countMax + " at " + biome.func_185359_l());
            }
        }
    }

    public static void reload() {
        for (int i = entries.size() - 1; i >= 0; --i) {
            SpawnEntry e = entries.get(i);
            List spawns = e.biome.func_76747_a(e.type);
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.field_76300_b != e.mob) continue;
                if (e.add) {
                    entry.field_76292_a = 0;
                    LogManager.getLogger((String)"nmsot").info("  removed spawn entry " + e.mob.getSimpleName() + ": " + e.weight + ", " + e.countMin + ", " + e.countMax + " at " + e.biome.func_185359_l());
                    continue;
                }
                entry.field_76292_a = e.weight;
                entry.field_76301_c = e.countMin;
                entry.field_76299_d = e.countMax;
                LogManager.getLogger((String)"nmsot").info("  re-added spawn entry " + e.mob.getSimpleName() + ": " + e.weight + ", " + e.countMin + ", " + e.countMax + " at " + e.biome.func_185359_l());
            }
        }
        entries.clear();
    }

    public static final class SpawnEntry {
        public boolean add = true;
        public int weight;
        public int countMin;
        public int countMax;
        public EnumCreatureType type;
        public Biome biome;
        public Class<? extends Entity> mob;
    }
}

