/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot.rule;

import com.mmyzd.nmsot.SpawningEntry;
import com.mmyzd.nmsot.rule.Rule;
import com.mmyzd.nmsot.rule.RuleSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import org.apache.logging.log4j.LogManager;

public class RuleMob
extends Rule {
    public Class<? extends Entity> entityClass = null;
    public HashSet<Class<? extends Entity>> entityClasses = null;
    private static HashMap<String, HashSet<Class<? extends Entity>>> classNames = null;
    private static HashMap<String, HashSet<Class<? extends Entity>>> mobNames = null;
    private static HashMap<String, HashSet<Class<? extends Entity>>> mobFullNames;

    public RuleMob(LinkedList<Character> s) throws Exception {
        RuleSet.nextPart(s);
        if (classNames == null) {
            classNames = new HashMap();
            mobNames = new HashMap();
            mobFullNames = new HashMap();
            Map entityList = EntityList.field_75626_c;
            for (Map.Entry e : entityList.entrySet()) {
                Class key = (Class)e.getKey();
                String value = (String)e.getValue();
                value = value.toLowerCase().replaceAll("\\s", "");
                this.addMobLookup(mobFullNames, value, key);
                this.addMobLookup(mobNames, value.substring(value.indexOf(46) + 1), key);
                this.addMobLookup(classNames, key.getSimpleName(), key);
            }
        }
        String name = RuleSet.getToken(s).toLowerCase();
        HashSet<Class<? extends Entity>> classNameGroup = classNames.get(name);
        HashSet<Class<? extends Entity>> mobNameGroup = mobNames.get(name);
        HashSet<Class<? extends Entity>> mobFullNameGroup = mobFullNames.get(name);
        if (mobFullNameGroup != null && mobFullNameGroup.size() == 1) {
            this.entityClass = mobFullNameGroup.iterator().next();
        } else if (classNameGroup != null && classNameGroup.size() == 1) {
            this.entityClass = classNameGroup.iterator().next();
        } else if (mobNameGroup != null && mobNameGroup.size() == 1) {
            this.entityClass = mobNameGroup.iterator().next();
        } else if (mobFullNameGroup != null) {
            this.entityClasses = mobFullNameGroup;
        } else if (classNameGroup != null) {
            this.entityClasses = classNameGroup;
        } else if (mobNameGroup != null) {
            this.entityClasses = mobNameGroup;
        }
        if (this.entityClasses == null && this.entityClass == null) {
            LogManager.getLogger((String)"nmsot").warn("Can not find this mob: " + name);
        }
    }

    private void addMobLookup(HashMap<String, HashSet<Class<? extends Entity>>> lookup, String key, Class<? extends Entity> value) {
        HashSet<Class<Object>> group = lookup.get(key);
        if (group == null) {
            group = new HashSet();
            lookup.put(key, group);
        }
        group.add(value);
    }

    @Override
    public boolean apply(SpawningEntry entry) {
        return this.entityClasses == null ? this.entityClass == entry.entity.getClass() : this.entityClasses.contains(entry.entity.getClass());
    }
}

